/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.informers;

import io.fabric8.kubernetes.api.model.v5_9.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v5_9.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_9.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_9.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_9.CustomResource;
import io.fabric8.kubernetes.clnt.v5_9.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_9.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_9.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.clnt.v5_9.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_9.utils.Utils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedInformerFactory {
    private static final Logger log = LoggerFactory.getLogger(SharedInformerFactory.class);
    private final List<Map.Entry<OperationContext, SharedIndexInformer>> informers = new ArrayList<Map.Entry<OperationContext, SharedIndexInformer>>();
    private final ExecutorService informerExecutor;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();
    private boolean allowShutdown = true;
    private String name;
    private String namespace;
    private BaseKubernetesClient<?> client;

    public SharedInformerFactory(BaseKubernetesClient<?> client) {
        this(client, Utils.getCommonExecutorSerive());
        this.allowShutdown = false;
    }

    public SharedInformerFactory(BaseKubernetesClient<?> client, ExecutorService threadPool) {
        this.informerExecutor = threadPool;
        this.client = client;
    }

    @Deprecated
    public SharedInformerFactory inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Deprecated
    public SharedInformerFactory withName(String name) {
        this.name = name;
        return this;
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, null, null, resyncPeriodInMillis, ResourceDefinitionContext.fromResourceType(apiTypeClass));
    }

    @Deprecated
    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, null, operationContext, resyncPeriodInMillis, ResourceDefinitionContext.fromResourceType(apiTypeClass));
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, null, resyncPeriodInMillis, customResourceContext);
    }

    @Deprecated
    public synchronized SharedIndexInformer<GenericKubernetesResource> sharedIndexInformerForCustomResource(ResourceDefinitionContext genericResourceContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(GenericKubernetesResource.class, GenericKubernetesResourceList.class, null, resyncPeriodInMillis, genericResourceContext);
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, null, operationContext, resyncPeriodInMillis, ResourceDefinitionContext.fromResourceType(apiTypeClass));
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerForCustomResource(apiTypeClass, (Class)null, resyncPeriodInMillis);
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, null, resyncPeriodInMillis, ResourceDefinitionContext.fromResourceType(apiTypeClass));
    }

    private synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis, ResourceDefinitionContext rdc) {
        HasMetadataOperationsImpl<T, L> resources = this.getResourceOperation(apiTypeClass, apiListTypeClass, operationContext, rdc);
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(apiTypeClass, resources.withResourceVersion(null), resyncPeriodInMillis, this.informerExecutor);
        this.informers.add(new AbstractMap.SimpleEntry(resources.getOperationContext(), informer));
        return informer;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> getResourceOperation(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, ResourceDefinitionContext rdc) {
        if (operationContext != null) {
            rdc = new ResourceDefinitionContext.Builder().withGroup(Utils.coalesce(operationContext.getApiGroupName(), rdc.getGroup())).withVersion(Utils.coalesce(operationContext.getApiGroupVersion(), rdc.getVersion())).withPlural(Utils.coalesce(operationContext.getPlural(), rdc.getPlural())).withNamespaced(rdc.isNamespaceScoped()).withKind(rdc.getKind()).build();
        }
        MixedOperation resources = this.client.customResources(rdc, (Class)apiTypeClass, (Class)apiListTypeClass);
        resources = this.namespace != null ? (HasMetadataOperationsImpl)((BaseOperation)resources).inNamespace(this.namespace) : (HasMetadataOperationsImpl)((BaseOperation)resources).inAnyNamespace();
        if (this.name != null) {
            resources = (HasMetadataOperationsImpl)((BaseOperation)resources).withName(this.name);
        }
        if (operationContext != null) {
            OperationContext context = ((HasMetadataOperationsImpl)resources).getOperationContext().withOperationContext(operationContext);
            if (operationContext.getNamespace() != null) {
                context = context.withIsNamespaceConfiguredFromGlobalConfig(false);
            }
            resources = ((HasMetadataOperationsImpl)resources).newInstance(context);
        }
        return resources;
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        for (Map.Entry<OperationContext, SharedIndexInformer> entry : this.informers) {
            if (!entry.getValue().getApiTypeClass().equals(apiTypeClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Deprecated
    public List<Map.Entry<OperationContext, SharedIndexInformer>> getExistingSharedIndexInformers() {
        return Collections.unmodifiableList(this.informers);
    }

    public synchronized Future<Void> startAllRegisteredInformers() {
        ArrayList<CompletableFuture<Boolean>> startInformerTasks = new ArrayList<CompletableFuture<Boolean>>();
        if (!this.informers.isEmpty() && !this.informerExecutor.isShutdown()) {
            for (Map.Entry<OperationContext, SharedIndexInformer> entry : this.informers) {
                startInformerTasks.add(this.startInformerAsync(entry.getValue()));
            }
        }
        return CompletableFuture.allOf(startInformerTasks.toArray(new CompletableFuture[0]));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        this.informers.forEach(e -> ((SharedIndexInformer)e.getValue()).stop());
        if (shutDownThreadPool && this.allowShutdown) {
            this.informerExecutor.shutdown();
        }
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }

    private synchronized CompletableFuture<Boolean> startInformerAsync(SharedIndexInformer informer) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        this.informerExecutor.submit(() -> {
            try {
                informer.run();
                completableFuture.complete(true);
            }
            catch (RuntimeException e) {
                if (this.eventListeners.isEmpty()) {
                    log.warn("Failed to start informer", (Throwable)e);
                } else {
                    this.eventListeners.forEach(listener -> listener.onException(informer, e));
                }
                completableFuture.completeExceptionally(e);
            }
        });
        return completableFuture;
    }
}

