/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.v5_9.Container;
import io.fabric8.kubernetes.api.model.v5_9.Pod;
import io.fabric8.kubernetes.api.model.v5_9.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_9.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_9.Status;
import io.fabric8.kubernetes.api.model.v5_9.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_9.Config;
import io.fabric8.kubernetes.clnt.v5_9.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_9.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_9.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_9.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_9.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.core.v1.ReplicationControllerRollingUpdater;
import io.fabric8.kubernetes.clnt.v5_9.utils.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicationControllerOperationsImpl
extends RollableScalableResourceOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>>
implements TimeoutImageEditReplacePatchable<ReplicationController> {
    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public ReplicationControllerOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext(), new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public ReplicationControllerOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withPlural("replicationcontrollers"), ReplicationController.class, ReplicationControllerList.class);
    }

    public ReplicationControllerOperationsImpl newInstance(OperationContext context) {
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicationControllerOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicationControllerOperationsImpl(context, this.context);
    }

    @Override
    public RollableScalableResource<ReplicationController> load(InputStream is) {
        ReplicationController item = ReplicationControllerOperationsImpl.unmarshal(is, ReplicationController.class);
        return new ReplicationControllerOperationsImpl(this.rollingOperationContext, this.context.withItem(item));
    }

    @Override
    public ReplicationController withReplicas(int count) {
        return this.cascading(false).accept((T r) -> r.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<ReplicationController, ReplicationControllerList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicationControllerRollingUpdater(this.client, this.config, this.namespace, rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicationController current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicationController item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicationController current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public ReplicationController updateImage(Map<String, String> containerToImageMap) {
        ReplicationController replicationController = (ReplicationController)this.get();
        if (replicationController == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (replicationController.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List<Container> containers = replicationController.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        replicationController.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), replicationController);
    }

    @Override
    public ReplicationController updateImage(String image) {
        ReplicationController oldRC = (ReplicationController)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replication controller doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    @Override
    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicationControllers");
    }

    @Override
    public String getLog(Boolean isPretty) {
        return PodOperationUtil.getLog(this.doGetLog(isPretty), isPretty);
    }

    private List<PodResource<Pod>> doGetLog(boolean isPretty) {
        ReplicationController rc = (ReplicationController)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, rc.getMetadata().getUid(), ReplicationControllerOperationsImpl.getReplicationControllerPodLabels(rc), isPretty, this.rollingOperationContext.getLogWaitTimeout(), this.rollingOperationContext.getContainerId());
    }

    @Override
    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog(false));
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(false), out);
    }

    @Override
    public ReplicationController pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    @Override
    public ReplicationController resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    @Override
    public ReplicationController restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    @Override
    public ReplicationController undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicationController)this.get()).getKind() + "\"");
    }

    static Map<String, String> getReplicationControllerPodLabels(ReplicationController replicationController) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicationController != null && replicationController.getSpec() != null && replicationController.getSpec().getSelector() != null) {
            labels.putAll(replicationController.getSpec().getSelector());
        }
        return labels;
    }
}

