/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_9.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_9.ListOptions;
import io.fabric8.kubernetes.clnt.v5_9.Watcher;
import io.fabric8.kubernetes.clnt.v5_9.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v5_9.dsl.internal.WatcherWebSocketListener;
import java.net.MalformedURLException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchConnectionManager<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends AbstractWatchManager<T> {
    private static final Logger logger = LoggerFactory.getLogger(WatchConnectionManager.class);
    protected WatcherWebSocketListener<T> listener;
    private WebSocket websocket;

    static void closeWebSocket(WebSocket webSocket) {
        if (webSocket != null) {
            logger.debug("Closing websocket {}", (Object)webSocket);
            try {
                if (!webSocket.close(1000, null)) {
                    logger.debug("Websocket already closed {}", (Object)webSocket);
                }
            }
            catch (IllegalStateException e) {
                logger.error("invalid code for websocket: {} {}", e.getClass(), (Object)e.getMessage());
            }
        }
    }

    static void closeBody(Response response) {
        if (response != null && response.body() != null) {
            response.body().close();
        }
    }

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout, int maxIntervalExponent) throws MalformedURLException {
        super(watcher, baseOperation, listOptions, reconnectLimit, reconnectInterval, maxIntervalExponent, () -> client.newBuilder().readTimeout(websocketTimeout, TimeUnit.MILLISECONDS).build());
    }

    public WatchConnectionManager(OkHttpClient client, BaseOperation<T, L, ?> baseOperation, ListOptions listOptions, Watcher<T> watcher, int reconnectInterval, int reconnectLimit, long websocketTimeout) throws MalformedURLException {
        this(client, baseOperation, listOptions, watcher, reconnectInterval, reconnectLimit, websocketTimeout, 5);
    }

    @Override
    protected synchronized void closeRequest() {
        WatchConnectionManager.closeWebSocket(this.websocket);
        this.websocket = null;
    }

    public void waitUntilReady() {
        this.getListener().waitUntilReady();
    }

    synchronized WatcherWebSocketListener<T> getListener() {
        return this.listener;
    }

    @Override
    protected synchronized void run(Request request) {
        this.listener = new WatcherWebSocketListener(this);
        this.websocket = this.client.newWebSocket(request, this.listener);
    }
}

