/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9.dsl.base;

import io.fabric8.kubernetes.api.model.v5_9.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_9.KubernetesResource;
import io.fabric8.kubernetes.clnt.v5_9.utils.Utils;

public class ResourceDefinitionContext {
    protected String group;
    protected boolean namespaced;
    protected String plural;
    protected String version;
    protected String kind;

    public String getGroup() {
        return this.group;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean isNamespaceScoped() {
        return this.namespaced;
    }

    public static ResourceDefinitionContext fromResourceType(Class<? extends KubernetesResource> resource) {
        return new Builder().withGroup(HasMetadata.getGroup(resource)).withVersion(HasMetadata.getVersion(resource)).withNamespaced(Utils.isResourceNamespaced(resource)).withPlural(HasMetadata.getPlural(resource)).withKind(HasMetadata.getKind(resource)).build();
    }

    public static class Builder {
        private final ResourceDefinitionContext resourceDefinitionContext = new ResourceDefinitionContext();

        public Builder withGroup(String group) {
            this.resourceDefinitionContext.group = group;
            return this;
        }

        public Builder withNamespaced(boolean namespaced) {
            this.resourceDefinitionContext.namespaced = namespaced;
            return this;
        }

        public Builder withPlural(String plural) {
            this.resourceDefinitionContext.plural = plural;
            return this;
        }

        public Builder withVersion(String version) {
            this.resourceDefinitionContext.version = version;
            return this;
        }

        public Builder withKind(String kind) {
            this.resourceDefinitionContext.kind = kind;
            return this;
        }

        public ResourceDefinitionContext build() {
            return this.resourceDefinitionContext;
        }
    }
}

