/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9;

import io.fabric8.kubernetes.api.model.v5_9.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_9.KubernetesClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class KubernetesClientTimeoutException
extends KubernetesClientException {
    private static final String RESOURCE_FORMAT = "Timed out waiting for [%d] milliseconds for [%s] with name:[%s] in namespace [%s].";
    private static final String KNOWS_RESOURCES_FORMAT = "Timed out waiting for [%d] milliseconds for multiple resources. %s";
    private final List<HasMetadata> resourcesNotReady;

    public KubernetesClientTimeoutException(String kind, String name, String namespace, long amount, TimeUnit timeUnit) {
        super(String.format(RESOURCE_FORMAT, timeUnit.toMillis(amount), kind, name, namespace));
        this.resourcesNotReady = Collections.emptyList();
    }

    public KubernetesClientTimeoutException(HasMetadata resource, long amount, TimeUnit timeUnit) {
        super(String.format(RESOURCE_FORMAT, timeUnit.toMillis(amount), resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()));
        this.resourcesNotReady = Collections.unmodifiableList(Arrays.asList(resource));
    }

    public KubernetesClientTimeoutException(Collection<HasMetadata> resourcesNotReady, long amount, TimeUnit timeUnit) {
        super(String.format(KNOWS_RESOURCES_FORMAT, timeUnit.toMillis(amount), KubernetesClientTimeoutException.notReadyToString(resourcesNotReady)));
        this.resourcesNotReady = Collections.unmodifiableList(new ArrayList<HasMetadata>(resourcesNotReady));
    }

    public List<HasMetadata> getResourcesNotReady() {
        return this.resourcesNotReady;
    }

    private static String notReadyToString(Iterable<HasMetadata> resources) {
        StringBuilder sb = new StringBuilder();
        sb.append("Resources that are not ready: ");
        boolean first = true;
        for (HasMetadata r : resources) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append("[Kind:").append(r.getKind()).append(" Name:").append(r.getMetadata().getName()).append(" Namespace:").append(r.getMetadata().getNamespace()).append("]");
        }
        return sb.toString();
    }
}

