/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_9;

import io.fabric8.kubernetes.clnt.v5_9.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_9.Config;
import io.fabric8.kubernetes.clnt.v5_9.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_9.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_9.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_9.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_9.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_9.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_9.utils.Serialization;
import java.io.InputStream;
import okhttp3.OkHttpClient;

public class DefaultKubernetesClient
extends BaseKubernetesClient<NamespacedKubernetesClient>
implements NamespacedKubernetesClient {
    public DefaultKubernetesClient() {
    }

    public DefaultKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    public DefaultKubernetesClient(Config config) {
        super(config);
    }

    public DefaultKubernetesClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public static DefaultKubernetesClient fromConfig(String config) {
        return new DefaultKubernetesClient(Serialization.unmarshal(config, Config.class));
    }

    public static DefaultKubernetesClient fromConfig(InputStream is) {
        return new DefaultKubernetesClient(Serialization.unmarshal(is, Config.class));
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String name) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(name)).build();
        return new DefaultKubernetesClient(this.httpClient, updated);
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedKubernetesClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedKubernetesClient>(this, requestConfig);
    }
}

