/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_9.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1.CSIDriver;
import io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1.CSIDriverFluent;
import io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1.CSIDriverSpec;
import io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1.CSIDriverSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_9.storage.v1beta1.CSIDriverSpecFluentImpl;
import java.util.Objects;

public class CSIDriverFluentImpl<A extends CSIDriverFluent<A>>
extends BaseFluent<A>
implements CSIDriverFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private CSIDriverSpecBuilder spec;

    public CSIDriverFluentImpl() {
    }

    public CSIDriverFluentImpl(CSIDriver instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public CSIDriverFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public CSIDriverFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public CSIDriverFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public CSIDriverFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public CSIDriverFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public CSIDriverSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public CSIDriverSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(CSIDriverSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new CSIDriverSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public CSIDriverFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public CSIDriverFluent.SpecNested<A> withNewSpecLike(CSIDriverSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public CSIDriverFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public CSIDriverFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new CSIDriverSpecBuilder().build());
    }

    @Override
    public CSIDriverFluent.SpecNested<A> editOrNewSpecLike(CSIDriverSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSIDriverFluentImpl that = (CSIDriverFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.spec != null ? !this.spec.equals(that.spec) : that.spec != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, super.hashCode());
    }

    public class SpecNestedImpl<N>
    extends CSIDriverSpecFluentImpl<CSIDriverFluent.SpecNested<N>>
    implements CSIDriverFluent.SpecNested<N>,
    Nested<N> {
        CSIDriverSpecBuilder builder;

        SpecNestedImpl(CSIDriverSpec item) {
            this.builder = new CSIDriverSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new CSIDriverSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIDriverFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<CSIDriverFluent.MetadataNested<N>>
    implements CSIDriverFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIDriverFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

