/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.rbac;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_9.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.v5_9.rbac.PolicyRuleFluent;
import io.fabric8.kubernetes.api.model.v5_9.rbac.PolicyRuleFluentImpl;
import java.util.Objects;

public class PolicyRuleBuilder
extends PolicyRuleFluentImpl<PolicyRuleBuilder>
implements VisitableBuilder<PolicyRule, PolicyRuleBuilder> {
    PolicyRuleFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyRuleBuilder() {
        this(false);
    }

    public PolicyRuleBuilder(Boolean validationEnabled) {
        this(new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PolicyRule(), validationEnabled);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, PolicyRule instance) {
        this(fluent, instance, false);
    }

    public PolicyRuleBuilder(PolicyRuleFluent<?> fluent, PolicyRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroups(instance.getApiGroups());
        fluent.withNonResourceURLs(instance.getNonResourceURLs());
        fluent.withResourceNames(instance.getResourceNames());
        fluent.withResources(instance.getResources());
        fluent.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    public PolicyRuleBuilder(PolicyRule instance) {
        this(instance, (Boolean)false);
    }

    public PolicyRuleBuilder(PolicyRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroups(instance.getApiGroups());
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PolicyRule build() {
        PolicyRule buildable = new PolicyRule(this.fluent.getApiGroups(), this.fluent.getNonResourceURLs(), this.fluent.getResourceNames(), this.fluent.getResources(), this.fluent.getVerbs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRuleBuilder that = (PolicyRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

