/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.IngressBackendFluentImpl;
import java.util.Objects;

public class IngressBackendBuilder
extends IngressBackendFluentImpl<IngressBackendBuilder>
implements VisitableBuilder<IngressBackend, IngressBackendBuilder> {
    IngressBackendFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBackendBuilder() {
        this(false);
    }

    public IngressBackendBuilder(Boolean validationEnabled) {
        this(new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressBackend(), validationEnabled);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance) {
        this(fluent, instance, false);
    }

    public IngressBackendBuilder(IngressBackendFluent<?> fluent, IngressBackend instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withResource(instance.getResource());
        fluent.withService(instance.getService());
        this.validationEnabled = validationEnabled;
    }

    public IngressBackendBuilder(IngressBackend instance) {
        this(instance, (Boolean)false);
    }

    public IngressBackendBuilder(IngressBackend instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withResource(instance.getResource());
        this.withService(instance.getService());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressBackend build() {
        IngressBackend buildable = new IngressBackend(this.fluent.getResource(), this.fluent.getService());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendBuilder that = (IngressBackendBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

