/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.IPBlock;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.IPBlockFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IPBlockFluentImpl<A extends IPBlockFluent<A>>
extends BaseFluent<A>
implements IPBlockFluent<A> {
    private String cidr;
    private List<String> except = new ArrayList<String>();

    public IPBlockFluentImpl() {
    }

    public IPBlockFluentImpl(IPBlock instance) {
        this.withCidr(instance.getCidr());
        this.withExcept(instance.getExcept());
    }

    @Override
    public String getCidr() {
        return this.cidr;
    }

    @Override
    public A withCidr(String cidr) {
        this.cidr = cidr;
        return (A)this;
    }

    @Override
    public Boolean hasCidr() {
        return this.cidr != null;
    }

    @Override
    @Deprecated
    public A withNewCidr(String arg0) {
        return this.withCidr(new String(arg0));
    }

    @Override
    public A addToExcept(Integer index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExcept(Integer index, String item) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExcept(String ... items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExcept(Collection<String> items) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        for (String item : items) {
            this.except.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExcept(String ... items) {
        for (String item : items) {
            if (this.except == null) continue;
            this.except.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExcept(Collection<String> items) {
        for (String item : items) {
            if (this.except == null) continue;
            this.except.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExcept() {
        return this.except;
    }

    @Override
    public String getExcept(Integer index) {
        return this.except.get(index);
    }

    @Override
    public String getFirstExcept() {
        return this.except.get(0);
    }

    @Override
    public String getLastExcept() {
        return this.except.get(this.except.size() - 1);
    }

    @Override
    public String getMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExcept(Predicate<String> predicate) {
        for (String item : this.except) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExcept(List<String> except) {
        if (except != null) {
            this.except = new ArrayList<String>();
            for (String item : except) {
                this.addToExcept(item);
            }
        } else {
            this.except = null;
        }
        return (A)this;
    }

    @Override
    public A withExcept(String ... except) {
        if (this.except != null) {
            this.except.clear();
        }
        if (except != null) {
            for (String item : except) {
                this.addToExcept(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExcept() {
        return this.except != null && !this.except.isEmpty();
    }

    @Override
    public A addNewExcept(String arg0) {
        return this.addToExcept(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPBlockFluentImpl that = (IPBlockFluentImpl)o;
        if (this.cidr != null ? !this.cidr.equals(that.cidr) : that.cidr != null) {
            return false;
        }
        return !(this.except != null ? !this.except.equals(that.except) : that.except != null);
    }

    public int hashCode() {
        return Objects.hash(this.cidr, this.except, super.hashCode());
    }
}

