/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.HTTPIngressPathFluentImpl;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.HTTPIngressRuleValue;
import io.fabric8.kubernetes.api.model.v5_9.networking.v1.HTTPIngressRuleValueFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPIngressRuleValueFluentImpl<A extends HTTPIngressRuleValueFluent<A>>
extends BaseFluent<A>
implements HTTPIngressRuleValueFluent<A> {
    private List<HTTPIngressPathBuilder> paths = new ArrayList<HTTPIngressPathBuilder>();

    public HTTPIngressRuleValueFluentImpl() {
    }

    public HTTPIngressRuleValueFluentImpl(HTTPIngressRuleValue instance) {
        this.withPaths(instance.getPaths());
    }

    @Override
    public A addToPaths(Integer index, HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList<HTTPIngressPathBuilder>();
        }
        HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
        this._visitables.get("paths").add(index >= 0 ? index.intValue() : this._visitables.get("paths").size(), builder);
        this.paths.add(index >= 0 ? index.intValue() : this.paths.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPaths(Integer index, HTTPIngressPath item) {
        if (this.paths == null) {
            this.paths = new ArrayList<HTTPIngressPathBuilder>();
        }
        HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
        if (index < 0 || index >= this._visitables.get("paths").size()) {
            this._visitables.get("paths").add(builder);
        } else {
            this._visitables.get("paths").set(index, builder);
        }
        if (index < 0 || index >= this.paths.size()) {
            this.paths.add(builder);
        } else {
            this.paths.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPaths(HTTPIngressPath ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<HTTPIngressPathBuilder>();
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<HTTPIngressPath> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<HTTPIngressPathBuilder>();
        }
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get("paths").add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(HTTPIngressPath ... items) {
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<HTTPIngressPath> items) {
        for (HTTPIngressPath item : items) {
            HTTPIngressPathBuilder builder = new HTTPIngressPathBuilder(item);
            this._visitables.get("paths").remove(builder);
            if (this.paths == null) continue;
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPaths(Predicate<HTTPIngressPathBuilder> predicate) {
        if (this.paths == null) {
            return (A)this;
        }
        Iterator<HTTPIngressPathBuilder> each = this.paths.iterator();
        Object visitables = this._visitables.get("paths");
        while (each.hasNext()) {
            HTTPIngressPathBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HTTPIngressPath> getPaths() {
        return HTTPIngressRuleValueFluentImpl.build(this.paths);
    }

    @Override
    public List<HTTPIngressPath> buildPaths() {
        return HTTPIngressRuleValueFluentImpl.build(this.paths);
    }

    @Override
    public HTTPIngressPath buildPath(Integer index) {
        return this.paths.get(index).build();
    }

    @Override
    public HTTPIngressPath buildFirstPath() {
        return this.paths.get(0).build();
    }

    @Override
    public HTTPIngressPath buildLastPath() {
        return this.paths.get(this.paths.size() - 1).build();
    }

    @Override
    public HTTPIngressPath buildMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        for (HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        for (HTTPIngressPathBuilder item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<HTTPIngressPath> paths) {
        if (this.paths != null) {
            this._visitables.get("paths").removeAll(this.paths);
        }
        if (paths != null) {
            this.paths = new ArrayList<HTTPIngressPathBuilder>();
            for (HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(HTTPIngressPath ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (HTTPIngressPath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> addNewPathLike(HTTPIngressPath item) {
        return new PathsNestedImpl(-1, item);
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> setNewPathLike(Integer index, HTTPIngressPath item) {
        return new PathsNestedImpl(index, item);
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> editPath(Integer index) {
        if (this.paths.size() <= index) {
            throw new RuntimeException("Can't edit paths. Index exceeds size.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> editFirstPath() {
        if (this.paths.size() == 0) {
            throw new RuntimeException("Can't edit first paths. The list is empty.");
        }
        return this.setNewPathLike(0, this.buildPath(0));
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> editLastPath() {
        int index = this.paths.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last paths. The list is empty.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    @Override
    public HTTPIngressRuleValueFluent.PathsNested<A> editMatchingPath(Predicate<HTTPIngressPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.paths.size(); ++i) {
            if (!predicate.test(this.paths.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching paths. No match found.");
        }
        return this.setNewPathLike(index, this.buildPath(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPIngressRuleValueFluentImpl that = (HTTPIngressRuleValueFluentImpl)o;
        return !(this.paths != null ? !this.paths.equals(that.paths) : that.paths != null);
    }

    public int hashCode() {
        return Objects.hash(this.paths, super.hashCode());
    }

    public class PathsNestedImpl<N>
    extends HTTPIngressPathFluentImpl<HTTPIngressRuleValueFluent.PathsNested<N>>
    implements HTTPIngressRuleValueFluent.PathsNested<N>,
    Nested<N> {
        HTTPIngressPathBuilder builder;
        Integer index;

        PathsNestedImpl(Integer index, HTTPIngressPath item) {
            this.index = index;
            this.builder = new HTTPIngressPathBuilder(this, item);
        }

        PathsNestedImpl() {
            this.index = -1;
            this.builder = new HTTPIngressPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPIngressRuleValueFluentImpl.this.setToPaths(this.index, this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }
}

