/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.flowcontrol.v1beta1.ResourcePolicyRule;
import io.fabric8.kubernetes.api.model.v5_9.flowcontrol.v1beta1.ResourcePolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ResourcePolicyRuleFluentImpl<A extends ResourcePolicyRuleFluent<A>>
extends BaseFluent<A>
implements ResourcePolicyRuleFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private Boolean clusterScope;
    private List<String> namespaces = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public ResourcePolicyRuleFluentImpl() {
    }

    public ResourcePolicyRuleFluentImpl(ResourcePolicyRule instance) {
        this.withApiGroups(instance.getApiGroups());
        this.withClusterScope(instance.getClusterScope());
        this.withNamespaces(instance.getNamespaces());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToApiGroups(Integer index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiGroups(Integer index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiGroups(String ... items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    @Override
    public String getApiGroup(Integer index) {
        return this.apiGroups.get(index);
    }

    @Override
    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    @Override
    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    @Override
    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    @Override
    public A addNewApiGroup(String arg0) {
        return this.addToApiGroups(new String(arg0));
    }

    @Override
    public Boolean getClusterScope() {
        return this.clusterScope;
    }

    @Override
    public A withClusterScope(Boolean clusterScope) {
        this.clusterScope = clusterScope;
        return (A)this;
    }

    @Override
    public Boolean hasClusterScope() {
        return this.clusterScope != null;
    }

    @Override
    public A addToNamespaces(Integer index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(Integer index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(Integer index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg0) {
        return this.addToNamespaces(new String(arg0));
    }

    @Override
    public A addToResources(Integer index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(String ... items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public String getResource(Integer index) {
        return this.resources.get(index);
    }

    @Override
    public String getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addNewResource(String arg0) {
        return this.addToResources(new String(arg0));
    }

    @Override
    public A addToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(Integer index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public A addNewVerb(String arg0) {
        return this.addToVerbs(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcePolicyRuleFluentImpl that = (ResourcePolicyRuleFluentImpl)o;
        if (this.apiGroups != null ? !this.apiGroups.equals(that.apiGroups) : that.apiGroups != null) {
            return false;
        }
        if (this.clusterScope != null ? !this.clusterScope.equals(that.clusterScope) : that.clusterScope != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.clusterScope, this.namespaces, this.resources, this.verbs, super.hashCode());
    }
}

