/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_9.Nested;
import io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1.CustomResourceConversion;
import io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1.CustomResourceConversionFluent;
import io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1.WebhookClientConfig;
import io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1.WebhookClientConfigBuilder;
import io.fabric8.kubernetes.api.model.v5_9.apiextensions.v1beta1.WebhookClientConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>>
extends BaseFluent<A>
implements CustomResourceConversionFluent<A> {
    private List<String> conversionReviewVersions = new ArrayList<String>();
    private String strategy;
    private WebhookClientConfigBuilder webhookClientConfig;

    public CustomResourceConversionFluentImpl() {
    }

    public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
    }

    @Override
    public A addToConversionReviewVersions(Integer index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConversionReviewVersions(Integer index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConversionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    @Override
    public String getConversionReviewVersion(Integer index) {
        return this.conversionReviewVersions.get(index);
    }

    @Override
    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    @Override
    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    @Override
    public A addNewConversionReviewVersion(String arg0) {
        return this.addToConversionReviewVersions(new String(arg0));
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    @Deprecated
    public A withNewStrategy(String arg0) {
        return this.withStrategy(new String(arg0));
    }

    @Override
    @Deprecated
    public WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig != null ? this.webhookClientConfig.build() : null;
    }

    @Override
    public WebhookClientConfig buildWebhookClientConfig() {
        return this.webhookClientConfig != null ? this.webhookClientConfig.build() : null;
    }

    @Override
    public A withWebhookClientConfig(WebhookClientConfig webhookClientConfig) {
        this._visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
        if (webhookClientConfig != null) {
            this.webhookClientConfig = new WebhookClientConfigBuilder(webhookClientConfig);
            this._visitables.get("webhookClientConfig").add(this.webhookClientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhookClientConfig() {
        return this.webhookClientConfig != null;
    }

    @Override
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig() {
        return new WebhookClientConfigNestedImpl();
    }

    @Override
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(WebhookClientConfig item) {
        return new WebhookClientConfigNestedImpl(item);
    }

    @Override
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig());
    }

    @Override
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig() != null ? this.getWebhookClientConfig() : new WebhookClientConfigBuilder().build());
    }

    @Override
    public CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(WebhookClientConfig item) {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig() != null ? this.getWebhookClientConfig() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl)o;
        if (this.conversionReviewVersions != null ? !this.conversionReviewVersions.equals(that.conversionReviewVersions) : that.conversionReviewVersions != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.webhookClientConfig != null ? !this.webhookClientConfig.equals(that.webhookClientConfig) : that.webhookClientConfig != null);
    }

    public int hashCode() {
        return Objects.hash(this.conversionReviewVersions, this.strategy, this.webhookClientConfig, super.hashCode());
    }

    public class WebhookClientConfigNestedImpl<N>
    extends WebhookClientConfigFluentImpl<CustomResourceConversionFluent.WebhookClientConfigNested<N>>
    implements CustomResourceConversionFluent.WebhookClientConfigNested<N>,
    Nested<N> {
        WebhookClientConfigBuilder builder;

        WebhookClientConfigNestedImpl(WebhookClientConfig item) {
            this.builder = new WebhookClientConfigBuilder(this, item);
        }

        WebhookClientConfigNestedImpl() {
            this.builder = new WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)CustomResourceConversionFluentImpl.this.withWebhookClientConfig(this.builder.build());
        }

        @Override
        public N endWebhookClientConfig() {
            return this.and();
        }
    }
}

