/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.Status;
import io.fabric8.kubernetes.api.model.v5_9.admission.v1beta1.AdmissionResponse;
import io.fabric8.kubernetes.api.model.v5_9.admission.v1beta1.AdmissionResponseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AdmissionResponseFluentImpl<A extends AdmissionResponseFluent<A>>
extends BaseFluent<A>
implements AdmissionResponseFluent<A> {
    private Boolean allowed;
    private Map<String, String> auditAnnotations;
    private String patch;
    private String patchType;
    private Status status;
    private String uid;
    private List<String> warnings = new ArrayList<String>();

    public AdmissionResponseFluentImpl() {
    }

    public AdmissionResponseFluentImpl(AdmissionResponse instance) {
        this.withAllowed(instance.getAllowed());
        this.withAuditAnnotations(instance.getAuditAnnotations());
        this.withPatch(instance.getPatch());
        this.withPatchType(instance.getPatchType());
        this.withStatus(instance.getStatus());
        this.withUid(instance.getUid());
        this.withWarnings(instance.getWarnings());
    }

    @Override
    public Boolean getAllowed() {
        return this.allowed;
    }

    @Override
    public A withAllowed(Boolean allowed) {
        this.allowed = allowed;
        return (A)this;
    }

    @Override
    public Boolean hasAllowed() {
        return this.allowed != null;
    }

    @Override
    public A addToAuditAnnotations(String key, String value) {
        if (this.auditAnnotations == null && key != null && value != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.auditAnnotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null && map != null) {
            this.auditAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.auditAnnotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuditAnnotations(String key) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        if (key != null && this.auditAnnotations != null) {
            this.auditAnnotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAuditAnnotations(Map<String, String> map) {
        if (this.auditAnnotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.auditAnnotations == null) continue;
                this.auditAnnotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAuditAnnotations() {
        return this.auditAnnotations;
    }

    @Override
    public <K, V> A withAuditAnnotations(Map<String, String> auditAnnotations) {
        this.auditAnnotations = auditAnnotations == null ? null : new LinkedHashMap<String, String>(auditAnnotations);
        return (A)this;
    }

    @Override
    public Boolean hasAuditAnnotations() {
        return this.auditAnnotations != null;
    }

    @Override
    public String getPatch() {
        return this.patch;
    }

    @Override
    public A withPatch(String patch) {
        this.patch = patch;
        return (A)this;
    }

    @Override
    public Boolean hasPatch() {
        return this.patch != null;
    }

    @Override
    @Deprecated
    public A withNewPatch(String arg0) {
        return this.withPatch(new String(arg0));
    }

    @Override
    public String getPatchType() {
        return this.patchType;
    }

    @Override
    public A withPatchType(String patchType) {
        this.patchType = patchType;
        return (A)this;
    }

    @Override
    public Boolean hasPatchType() {
        return this.patchType != null;
    }

    @Override
    @Deprecated
    public A withNewPatchType(String arg0) {
        return this.withPatchType(new String(arg0));
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    @Deprecated
    public A withNewUid(String arg0) {
        return this.withUid(new String(arg0));
    }

    @Override
    public A addToWarnings(Integer index, String item) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(index, item);
        return (A)this;
    }

    @Override
    public A setToWarnings(Integer index, String item) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.set(index, item);
        return (A)this;
    }

    @Override
    public A addToWarnings(String ... items) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        for (String item : items) {
            this.warnings.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToWarnings(Collection<String> items) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        for (String item : items) {
            this.warnings.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromWarnings(String ... items) {
        for (String item : items) {
            if (this.warnings == null) continue;
            this.warnings.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromWarnings(Collection<String> items) {
        for (String item : items) {
            if (this.warnings == null) continue;
            this.warnings.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public String getWarning(Integer index) {
        return this.warnings.get(index);
    }

    @Override
    public String getFirstWarning() {
        return this.warnings.get(0);
    }

    @Override
    public String getLastWarning() {
        return this.warnings.get(this.warnings.size() - 1);
    }

    @Override
    public String getMatchingWarning(Predicate<String> predicate) {
        for (String item : this.warnings) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingWarning(Predicate<String> predicate) {
        for (String item : this.warnings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withWarnings(List<String> warnings) {
        if (warnings != null) {
            this.warnings = new ArrayList<String>();
            for (String item : warnings) {
                this.addToWarnings(item);
            }
        } else {
            this.warnings = null;
        }
        return (A)this;
    }

    @Override
    public A withWarnings(String ... warnings) {
        if (this.warnings != null) {
            this.warnings.clear();
        }
        if (warnings != null) {
            for (String item : warnings) {
                this.addToWarnings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasWarnings() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    @Override
    public A addNewWarning(String arg0) {
        return this.addToWarnings(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdmissionResponseFluentImpl that = (AdmissionResponseFluentImpl)o;
        if (this.allowed != null ? !this.allowed.equals(that.allowed) : that.allowed != null) {
            return false;
        }
        if (this.auditAnnotations != null ? !this.auditAnnotations.equals(that.auditAnnotations) : that.auditAnnotations != null) {
            return false;
        }
        if (this.patch != null ? !this.patch.equals(that.patch) : that.patch != null) {
            return false;
        }
        if (this.patchType != null ? !this.patchType.equals(that.patchType) : that.patchType != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.uid != null ? !this.uid.equals(that.uid) : that.uid != null) {
            return false;
        }
        return !(this.warnings != null ? !this.warnings.equals(that.warnings) : that.warnings != null);
    }

    public int hashCode() {
        return Objects.hash(this.allowed, this.auditAnnotations, this.patch, this.patchType, this.status, this.uid, this.warnings, super.hashCode());
    }
}

