/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_9.Toleration;
import io.fabric8.kubernetes.api.model.v5_9.TolerationFluent;
import io.fabric8.kubernetes.api.model.v5_9.TolerationFluentImpl;
import java.util.Objects;

public class TolerationBuilder
extends TolerationFluentImpl<TolerationBuilder>
implements VisitableBuilder<Toleration, TolerationBuilder> {
    TolerationFluent<?> fluent;
    Boolean validationEnabled;

    public TolerationBuilder() {
        this(false);
    }

    public TolerationBuilder(Boolean validationEnabled) {
        this(new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Toleration(), validationEnabled);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance) {
        this(fluent, instance, false);
    }

    public TolerationBuilder(TolerationFluent<?> fluent, Toleration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withOperator(instance.getOperator());
        fluent.withTolerationSeconds(instance.getTolerationSeconds());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TolerationBuilder(Toleration instance) {
        this(instance, (Boolean)false);
    }

    public TolerationBuilder(Toleration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withOperator(instance.getOperator());
        this.withTolerationSeconds(instance.getTolerationSeconds());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Toleration build() {
        Toleration buildable = new Toleration(this.fluent.getEffect(), this.fluent.getKey(), this.fluent.getOperator(), this.fluent.getTolerationSeconds(), this.fluent.getValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TolerationBuilder that = (TolerationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

