/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.ScopedResourceSelectorRequirement;
import io.fabric8.kubernetes.api.model.v5_9.ScopedResourceSelectorRequirementFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ScopedResourceSelectorRequirementFluentImpl<A extends ScopedResourceSelectorRequirementFluent<A>>
extends BaseFluent<A>
implements ScopedResourceSelectorRequirementFluent<A> {
    private String operator;
    private String scopeName;
    private List<String> values = new ArrayList<String>();

    public ScopedResourceSelectorRequirementFluentImpl() {
    }

    public ScopedResourceSelectorRequirementFluentImpl(ScopedResourceSelectorRequirement instance) {
        this.withOperator(instance.getOperator());
        this.withScopeName(instance.getScopeName());
        this.withValues(instance.getValues());
    }

    @Override
    public String getOperator() {
        return this.operator;
    }

    @Override
    public A withOperator(String operator) {
        this.operator = operator;
        return (A)this;
    }

    @Override
    public Boolean hasOperator() {
        return this.operator != null;
    }

    @Override
    @Deprecated
    public A withNewOperator(String arg0) {
        return this.withOperator(new String(arg0));
    }

    @Override
    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public A withScopeName(String scopeName) {
        this.scopeName = scopeName;
        return (A)this;
    }

    @Override
    public Boolean hasScopeName() {
        return this.scopeName != null;
    }

    @Override
    @Deprecated
    public A withNewScopeName(String arg0) {
        return this.withScopeName(new String(arg0));
    }

    @Override
    public A addToValues(Integer index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.add(index, item);
        return (A)this;
    }

    @Override
    public A setToValues(Integer index, String item) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        this.values.set(index, item);
        return (A)this;
    }

    @Override
    public A addToValues(String ... items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToValues(Collection<String> items) {
        if (this.values == null) {
            this.values = new ArrayList<String>();
        }
        for (String item : items) {
            this.values.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromValues(String ... items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromValues(Collection<String> items) {
        for (String item : items) {
            if (this.values == null) continue;
            this.values.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getValues() {
        return this.values;
    }

    @Override
    public String getValue(Integer index) {
        return this.values.get(index);
    }

    @Override
    public String getFirstValue() {
        return this.values.get(0);
    }

    @Override
    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    @Override
    public String getMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingValue(Predicate<String> predicate) {
        for (String item : this.values) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withValues(List<String> values) {
        if (values != null) {
            this.values = new ArrayList<String>();
            for (String item : values) {
                this.addToValues(item);
            }
        } else {
            this.values = null;
        }
        return (A)this;
    }

    @Override
    public A withValues(String ... values) {
        if (this.values != null) {
            this.values.clear();
        }
        if (values != null) {
            for (String item : values) {
                this.addToValues(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasValues() {
        return this.values != null && !this.values.isEmpty();
    }

    @Override
    public A addNewValue(String arg0) {
        return this.addToValues(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScopedResourceSelectorRequirementFluentImpl that = (ScopedResourceSelectorRequirementFluentImpl)o;
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        if (this.scopeName != null ? !this.scopeName.equals(that.scopeName) : that.scopeName != null) {
            return false;
        }
        return !(this.values != null ? !this.values.equals(that.values) : that.values != null);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.scopeName, this.values, super.hashCode());
    }
}

