/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_9.NodeStatus;
import io.fabric8.kubernetes.api.model.v5_9.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.v5_9.NodeStatusFluentImpl;
import java.util.Objects;

public class NodeStatusBuilder
extends NodeStatusFluentImpl<NodeStatusBuilder>
implements VisitableBuilder<NodeStatus, NodeStatusBuilder> {
    NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NodeStatusBuilder() {
        this(false);
    }

    public NodeStatusBuilder(Boolean validationEnabled) {
        this(new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this(fluent, instance, false);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withAllocatable(instance.getAllocatable());
        fluent.withCapacity(instance.getCapacity());
        fluent.withConditions(instance.getConditions());
        fluent.withConfig(instance.getConfig());
        fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
        fluent.withImages(instance.getImages());
        fluent.withNodeInfo(instance.getNodeInfo());
        fluent.withPhase(instance.getPhase());
        fluent.withVolumesAttached(instance.getVolumesAttached());
        fluent.withVolumesInUse(instance.getVolumesInUse());
        this.validationEnabled = validationEnabled;
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this(instance, (Boolean)false);
    }

    public NodeStatusBuilder(NodeStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withConfig(instance.getConfig());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
        this.withVolumesAttached(instance.getVolumesAttached());
        this.withVolumesInUse(instance.getVolumesInUse());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(this.fluent.getAddresses(), this.fluent.getAllocatable(), this.fluent.getCapacity(), this.fluent.getConditions(), this.fluent.getConfig(), this.fluent.getDaemonEndpoints(), this.fluent.getImages(), this.fluent.getNodeInfo(), this.fluent.getPhase(), this.fluent.getVolumesAttached(), this.fluent.getVolumesInUse());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusBuilder that = (NodeStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

