/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.HostAlias;
import io.fabric8.kubernetes.api.model.v5_9.HostAliasFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class HostAliasFluentImpl<A extends HostAliasFluent<A>>
extends BaseFluent<A>
implements HostAliasFluent<A> {
    private List<String> hostnames = new ArrayList<String>();
    private String ip;

    public HostAliasFluentImpl() {
    }

    public HostAliasFluentImpl(HostAlias instance) {
        this.withHostnames(instance.getHostnames());
        this.withIp(instance.getIp());
    }

    @Override
    public A addToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHostnames(Integer index, String item) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHostnames(String ... items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostnames(Collection<String> items) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        for (String item : items) {
            this.hostnames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostnames(String ... items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostnames(Collection<String> items) {
        for (String item : items) {
            if (this.hostnames == null) continue;
            this.hostnames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHostnames() {
        return this.hostnames;
    }

    @Override
    public String getHostname(Integer index) {
        return this.hostnames.get(index);
    }

    @Override
    public String getFirstHostname() {
        return this.hostnames.get(0);
    }

    @Override
    public String getLastHostname() {
        return this.hostnames.get(this.hostnames.size() - 1);
    }

    @Override
    public String getMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHostname(Predicate<String> predicate) {
        for (String item : this.hostnames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHostnames(List<String> hostnames) {
        if (hostnames != null) {
            this.hostnames = new ArrayList<String>();
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        } else {
            this.hostnames = null;
        }
        return (A)this;
    }

    @Override
    public A withHostnames(String ... hostnames) {
        if (this.hostnames != null) {
            this.hostnames.clear();
        }
        if (hostnames != null) {
            for (String item : hostnames) {
                this.addToHostnames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostnames() {
        return this.hostnames != null && !this.hostnames.isEmpty();
    }

    @Override
    public A addNewHostname(String arg0) {
        return this.addToHostnames(new String(arg0));
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    @Deprecated
    public A withNewIp(String arg0) {
        return this.withIp(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAliasFluentImpl that = (HostAliasFluentImpl)o;
        if (this.hostnames != null ? !this.hostnames.equals(that.hostnames) : that.hostnames != null) {
            return false;
        }
        return !(this.ip != null ? !this.ip.equals(that.ip) : that.ip != null);
    }

    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip, super.hashCode());
    }
}

