/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_9;

import io.fabric8.kubernetes.api.builder.v5_9.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_9.APIResource;
import io.fabric8.kubernetes.api.model.v5_9.APIResourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class APIResourceFluentImpl<A extends APIResourceFluent<A>>
extends BaseFluent<A>
implements APIResourceFluent<A> {
    private List<String> categories = new ArrayList<String>();
    private String group;
    private String kind;
    private String name;
    private Boolean namespaced;
    private List<String> shortNames = new ArrayList<String>();
    private String singularName;
    private String storageVersionHash;
    private List<String> verbs = new ArrayList<String>();
    private String version;

    public APIResourceFluentImpl() {
    }

    public APIResourceFluentImpl(APIResource instance) {
        this.withCategories(instance.getCategories());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespaced(instance.getNamespaced());
        this.withShortNames(instance.getShortNames());
        this.withSingularName(instance.getSingularName());
        this.withStorageVersionHash(instance.getStorageVersionHash());
        this.withVerbs(instance.getVerbs());
        this.withVersion(instance.getVersion());
    }

    @Override
    public A addToCategories(Integer index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCategories(Integer index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCategories(String ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCategories(Collection<String> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCategories(String ... items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCategories(Collection<String> items) {
        for (String item : items) {
            if (this.categories == null) continue;
            this.categories.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public String getCategory(Integer index) {
        return this.categories.get(index);
    }

    @Override
    public String getFirstCategory() {
        return this.categories.get(0);
    }

    @Override
    public String getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    @Override
    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCategories(List<String> categories) {
        if (categories != null) {
            this.categories = new ArrayList<String>();
            for (String item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    @Override
    public A withCategories(String ... categories) {
        if (this.categories != null) {
            this.categories.clear();
        }
        if (categories != null) {
            for (String item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    @Override
    public A addNewCategory(String arg0) {
        return this.addToCategories(new String(arg0));
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    @Deprecated
    public A withNewGroup(String arg0) {
        return this.withGroup(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Boolean getNamespaced() {
        return this.namespaced;
    }

    @Override
    public A withNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
        return (A)this;
    }

    @Override
    public Boolean hasNamespaced() {
        return this.namespaced != null;
    }

    @Override
    public A addToShortNames(Integer index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToShortNames(Integer index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToShortNames(String ... items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromShortNames(String ... items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromShortNames(Collection<String> items) {
        for (String item : items) {
            if (this.shortNames == null) continue;
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getShortNames() {
        return this.shortNames;
    }

    @Override
    public String getShortName(Integer index) {
        return this.shortNames.get(index);
    }

    @Override
    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    @Override
    public String getLastShortName() {
        return this.shortNames.get(this.shortNames.size() - 1);
    }

    @Override
    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withShortNames(List<String> shortNames) {
        if (shortNames != null) {
            this.shortNames = new ArrayList<String>();
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        } else {
            this.shortNames = null;
        }
        return (A)this;
    }

    @Override
    public A withShortNames(String ... shortNames) {
        if (this.shortNames != null) {
            this.shortNames.clear();
        }
        if (shortNames != null) {
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasShortNames() {
        return this.shortNames != null && !this.shortNames.isEmpty();
    }

    @Override
    public A addNewShortName(String arg0) {
        return this.addToShortNames(new String(arg0));
    }

    @Override
    public String getSingularName() {
        return this.singularName;
    }

    @Override
    public A withSingularName(String singularName) {
        this.singularName = singularName;
        return (A)this;
    }

    @Override
    public Boolean hasSingularName() {
        return this.singularName != null;
    }

    @Override
    @Deprecated
    public A withNewSingularName(String arg0) {
        return this.withSingularName(new String(arg0));
    }

    @Override
    public String getStorageVersionHash() {
        return this.storageVersionHash;
    }

    @Override
    public A withStorageVersionHash(String storageVersionHash) {
        this.storageVersionHash = storageVersionHash;
        return (A)this;
    }

    @Override
    public Boolean hasStorageVersionHash() {
        return this.storageVersionHash != null;
    }

    @Override
    @Deprecated
    public A withNewStorageVersionHash(String arg0) {
        return this.withStorageVersionHash(new String(arg0));
    }

    @Override
    public A addToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(Integer index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public A addNewVerb(String arg0) {
        return this.addToVerbs(new String(arg0));
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    @Deprecated
    public A withNewVersion(String arg0) {
        return this.withVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIResourceFluentImpl that = (APIResourceFluentImpl)o;
        if (this.categories != null ? !this.categories.equals(that.categories) : that.categories != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.namespaced != null ? !this.namespaced.equals(that.namespaced) : that.namespaced != null) {
            return false;
        }
        if (this.shortNames != null ? !this.shortNames.equals(that.shortNames) : that.shortNames != null) {
            return false;
        }
        if (this.singularName != null ? !this.singularName.equals(that.singularName) : that.singularName != null) {
            return false;
        }
        if (this.storageVersionHash != null ? !this.storageVersionHash.equals(that.storageVersionHash) : that.storageVersionHash != null) {
            return false;
        }
        if (this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return Objects.hash(this.categories, this.group, this.kind, this.name, this.namespaced, this.shortNames, this.singularName, this.storageVersionHash, this.verbs, this.version, super.hashCode());
    }
}

