/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Update;
import io.fabric8.openshift.api.model.UpdateFluent;
import io.fabric8.openshift.api.model.UpdateFluentImpl;
import java.util.Objects;

public class UpdateBuilder
extends UpdateFluentImpl<UpdateBuilder>
implements VisitableBuilder<Update, UpdateBuilder> {
    UpdateFluent<?> fluent;
    Boolean validationEnabled;

    public UpdateBuilder() {
        this(false);
    }

    public UpdateBuilder(Boolean validationEnabled) {
        this(new Update(), validationEnabled);
    }

    public UpdateBuilder(UpdateFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public UpdateBuilder(UpdateFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Update(), validationEnabled);
    }

    public UpdateBuilder(UpdateFluent<?> fluent, Update instance) {
        this(fluent, instance, false);
    }

    public UpdateBuilder(UpdateFluent<?> fluent, Update instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withForce(instance.getForce());
        fluent.withImage(instance.getImage());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public UpdateBuilder(Update instance) {
        this(instance, (Boolean)false);
    }

    public UpdateBuilder(Update instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withForce(instance.getForce());
        this.withImage(instance.getImage());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Update build() {
        Update buildable = new Update(this.fluent.getForce(), this.fluent.getImage(), this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UpdateBuilder that = (UpdateBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

