/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.kubernetes.api.model.v5_8.ListMeta;
import io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1.IPPool;
import io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1.IPPoolBuilder;
import io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1.IPPoolFluentImpl;
import io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1.IPPoolList;
import io.fabric8.openshift.api.model.v5_8.whereabouts.v1alpha1.IPPoolListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IPPoolListFluentImpl<A extends IPPoolListFluent<A>>
extends BaseFluent<A>
implements IPPoolListFluent<A> {
    private String apiVersion;
    private List<IPPoolBuilder> items = new ArrayList<IPPoolBuilder>();
    private String kind;
    private ListMeta metadata;

    public IPPoolListFluentImpl() {
    }

    public IPPoolListFluentImpl(IPPoolList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(Integer index, IPPool item) {
        if (this.items == null) {
            this.items = new ArrayList<IPPoolBuilder>();
        }
        IPPoolBuilder builder = new IPPoolBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index.intValue() : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, IPPool item) {
        if (this.items == null) {
            this.items = new ArrayList<IPPoolBuilder>();
        }
        IPPoolBuilder builder = new IPPoolBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(IPPool ... items) {
        if (this.items == null) {
            this.items = new ArrayList<IPPoolBuilder>();
        }
        for (IPPool item : items) {
            IPPoolBuilder builder = new IPPoolBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<IPPool> items) {
        if (this.items == null) {
            this.items = new ArrayList<IPPoolBuilder>();
        }
        for (IPPool item : items) {
            IPPoolBuilder builder = new IPPoolBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(IPPool ... items) {
        for (IPPool item : items) {
            IPPoolBuilder builder = new IPPoolBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<IPPool> items) {
        for (IPPool item : items) {
            IPPoolBuilder builder = new IPPoolBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<IPPoolBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<IPPoolBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            IPPoolBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IPPool> getItems() {
        return IPPoolListFluentImpl.build(this.items);
    }

    @Override
    public List<IPPool> buildItems() {
        return IPPoolListFluentImpl.build(this.items);
    }

    @Override
    public IPPool buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public IPPool buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public IPPool buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public IPPool buildMatchingItem(Predicate<IPPoolBuilder> predicate) {
        for (IPPoolBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<IPPoolBuilder> predicate) {
        for (IPPoolBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<IPPool> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<IPPoolBuilder>();
            for (IPPool item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(IPPool ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (IPPool item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> addNewItemLike(IPPool item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> setNewItemLike(Integer index, IPPool item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public IPPoolListFluent.ItemsNested<A> editMatchingItem(Predicate<IPPoolBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPPoolListFluentImpl that = (IPPoolListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends IPPoolFluentImpl<IPPoolListFluent.ItemsNested<N>>
    implements IPPoolListFluent.ItemsNested<N>,
    Nested<N> {
        IPPoolBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, IPPool item) {
            this.index = index;
            this.builder = new IPPoolBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new IPPoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)IPPoolListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

