/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1.StorageStateStatus;
import io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1.StorageStateStatusFluent;
import io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1.StorageStateStatusFluentImpl;
import java.util.Objects;

public class StorageStateStatusBuilder
extends StorageStateStatusFluentImpl<StorageStateStatusBuilder>
implements VisitableBuilder<StorageStateStatus, StorageStateStatusBuilder> {
    StorageStateStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StorageStateStatusBuilder() {
        this(false);
    }

    public StorageStateStatusBuilder(Boolean validationEnabled) {
        this(new StorageStateStatus(), validationEnabled);
    }

    public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StorageStateStatus(), validationEnabled);
    }

    public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent, StorageStateStatus instance) {
        this(fluent, instance, false);
    }

    public StorageStateStatusBuilder(StorageStateStatusFluent<?> fluent, StorageStateStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
        fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        fluent.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
        this.validationEnabled = validationEnabled;
    }

    public StorageStateStatusBuilder(StorageStateStatus instance) {
        this(instance, (Boolean)false);
    }

    public StorageStateStatusBuilder(StorageStateStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
        this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StorageStateStatus build() {
        StorageStateStatus buildable = new StorageStateStatus(this.fluent.getCurrentStorageVersionHash(), this.fluent.getLastHeartbeatTime(), this.fluent.getPersistedStorageVersionHashes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StorageStateStatusBuilder that = (StorageStateStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

