/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.openshift.api.model.v5_8.TLSProfileSpec;
import io.fabric8.openshift.api.model.v5_8.TLSProfileSpecBuilder;
import io.fabric8.openshift.api.model.v5_8.TLSProfileSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_8.operator.v1.EndpointPublishingStrategy;
import io.fabric8.openshift.api.model.v5_8.operator.v1.EndpointPublishingStrategyBuilder;
import io.fabric8.openshift.api.model.v5_8.operator.v1.EndpointPublishingStrategyFluentImpl;
import io.fabric8.openshift.api.model.v5_8.operator.v1.IngressControllerStatus;
import io.fabric8.openshift.api.model.v5_8.operator.v1.IngressControllerStatusFluent;
import io.fabric8.openshift.api.model.v5_8.operator.v1.OperatorCondition;
import io.fabric8.openshift.api.model.v5_8.operator.v1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.v5_8.operator.v1.OperatorConditionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressControllerStatusFluentImpl<A extends IngressControllerStatusFluent<A>>
extends BaseFluent<A>
implements IngressControllerStatusFluent<A> {
    private Integer availableReplicas;
    private List<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();
    private String domain;
    private EndpointPublishingStrategyBuilder endpointPublishingStrategy;
    private Long observedGeneration;
    private String selector;
    private TLSProfileSpecBuilder tlsProfile;

    public IngressControllerStatusFluentImpl() {
    }

    public IngressControllerStatusFluentImpl(IngressControllerStatus instance) {
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withDomain(instance.getDomain());
        this.withEndpointPublishingStrategy(instance.getEndpointPublishingStrategy());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withSelector(instance.getSelector());
        this.withTlsProfile(instance.getTlsProfile());
    }

    @Override
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    @Override
    public A withAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasAvailableReplicas() {
        return this.availableReplicas != null;
    }

    @Override
    public A addToConditions(Integer index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(OperatorCondition ... items) {
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<OperatorConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            OperatorConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OperatorCondition> getConditions() {
        return IngressControllerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<OperatorCondition> buildConditions() {
        return IngressControllerStatusFluentImpl.build(this.conditions);
    }

    @Override
    public OperatorCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public OperatorCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, OperatorCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public IngressControllerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public A withDomain(String domain) {
        this.domain = domain;
        return (A)this;
    }

    @Override
    public Boolean hasDomain() {
        return this.domain != null;
    }

    @Override
    @Deprecated
    public A withNewDomain(String arg0) {
        return this.withDomain(new String(arg0));
    }

    @Override
    @Deprecated
    public EndpointPublishingStrategy getEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null ? this.endpointPublishingStrategy.build() : null;
    }

    @Override
    public EndpointPublishingStrategy buildEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null ? this.endpointPublishingStrategy.build() : null;
    }

    @Override
    public A withEndpointPublishingStrategy(EndpointPublishingStrategy endpointPublishingStrategy) {
        this._visitables.get("endpointPublishingStrategy").remove(this.endpointPublishingStrategy);
        if (endpointPublishingStrategy != null) {
            this.endpointPublishingStrategy = new EndpointPublishingStrategyBuilder(endpointPublishingStrategy);
            this._visitables.get("endpointPublishingStrategy").add(this.endpointPublishingStrategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpointPublishingStrategy() {
        return this.endpointPublishingStrategy != null;
    }

    @Override
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategy() {
        return new EndpointPublishingStrategyNestedImpl();
    }

    @Override
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> withNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return new EndpointPublishingStrategyNestedImpl(item);
    }

    @Override
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(this.getEndpointPublishingStrategy());
    }

    @Override
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategy() {
        return this.withNewEndpointPublishingStrategyLike(this.getEndpointPublishingStrategy() != null ? this.getEndpointPublishingStrategy() : new EndpointPublishingStrategyBuilder().build());
    }

    @Override
    public IngressControllerStatusFluent.EndpointPublishingStrategyNested<A> editOrNewEndpointPublishingStrategyLike(EndpointPublishingStrategy item) {
        return this.withNewEndpointPublishingStrategyLike(this.getEndpointPublishingStrategy() != null ? this.getEndpointPublishingStrategy() : item);
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(String selector) {
        this.selector = selector;
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public A withNewSelector(String arg0) {
        return this.withSelector(new String(arg0));
    }

    @Override
    @Deprecated
    public TLSProfileSpec getTlsProfile() {
        return this.tlsProfile != null ? this.tlsProfile.build() : null;
    }

    @Override
    public TLSProfileSpec buildTlsProfile() {
        return this.tlsProfile != null ? this.tlsProfile.build() : null;
    }

    @Override
    public A withTlsProfile(TLSProfileSpec tlsProfile) {
        this._visitables.get("tlsProfile").remove(this.tlsProfile);
        if (tlsProfile != null) {
            this.tlsProfile = new TLSProfileSpecBuilder(tlsProfile);
            this._visitables.get("tlsProfile").add(this.tlsProfile);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsProfile() {
        return this.tlsProfile != null;
    }

    @Override
    public IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfile() {
        return new TlsProfileNestedImpl();
    }

    @Override
    public IngressControllerStatusFluent.TlsProfileNested<A> withNewTlsProfileLike(TLSProfileSpec item) {
        return new TlsProfileNestedImpl(item);
    }

    @Override
    public IngressControllerStatusFluent.TlsProfileNested<A> editTlsProfile() {
        return this.withNewTlsProfileLike(this.getTlsProfile());
    }

    @Override
    public IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfile() {
        return this.withNewTlsProfileLike(this.getTlsProfile() != null ? this.getTlsProfile() : new TLSProfileSpecBuilder().build());
    }

    @Override
    public IngressControllerStatusFluent.TlsProfileNested<A> editOrNewTlsProfileLike(TLSProfileSpec item) {
        return this.withNewTlsProfileLike(this.getTlsProfile() != null ? this.getTlsProfile() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressControllerStatusFluentImpl that = (IngressControllerStatusFluentImpl)o;
        if (this.availableReplicas != null ? !this.availableReplicas.equals(that.availableReplicas) : that.availableReplicas != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) {
            return false;
        }
        if (this.endpointPublishingStrategy != null ? !this.endpointPublishingStrategy.equals(that.endpointPublishingStrategy) : that.endpointPublishingStrategy != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.tlsProfile != null ? !this.tlsProfile.equals(that.tlsProfile) : that.tlsProfile != null);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.conditions, this.domain, this.endpointPublishingStrategy, this.observedGeneration, this.selector, this.tlsProfile, super.hashCode());
    }

    public class TlsProfileNestedImpl<N>
    extends TLSProfileSpecFluentImpl<IngressControllerStatusFluent.TlsProfileNested<N>>
    implements IngressControllerStatusFluent.TlsProfileNested<N>,
    Nested<N> {
        TLSProfileSpecBuilder builder;

        TlsProfileNestedImpl(TLSProfileSpec item) {
            this.builder = new TLSProfileSpecBuilder(this, item);
        }

        TlsProfileNestedImpl() {
            this.builder = new TLSProfileSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluentImpl.this.withTlsProfile(this.builder.build());
        }

        @Override
        public N endTlsProfile() {
            return this.and();
        }
    }

    public class EndpointPublishingStrategyNestedImpl<N>
    extends EndpointPublishingStrategyFluentImpl<IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>>
    implements IngressControllerStatusFluent.EndpointPublishingStrategyNested<N>,
    Nested<N> {
        EndpointPublishingStrategyBuilder builder;

        EndpointPublishingStrategyNestedImpl(EndpointPublishingStrategy item) {
            this.builder = new EndpointPublishingStrategyBuilder(this, item);
        }

        EndpointPublishingStrategyNestedImpl() {
            this.builder = new EndpointPublishingStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluentImpl.this.withEndpointPublishingStrategy(this.builder.build());
        }

        @Override
        public N endEndpointPublishingStrategy() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends OperatorConditionFluentImpl<IngressControllerStatusFluent.ConditionsNested<N>>
    implements IngressControllerStatusFluent.ConditionsNested<N>,
    Nested<N> {
        OperatorConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new OperatorConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressControllerStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

