/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_8.machine.v1beta1.MachineSetStatus;
import io.fabric8.openshift.api.model.v5_8.machine.v1beta1.MachineSetStatusFluent;
import io.fabric8.openshift.api.model.v5_8.machine.v1beta1.MachineSetStatusFluentImpl;
import java.util.Objects;

public class MachineSetStatusBuilder
extends MachineSetStatusFluentImpl<MachineSetStatusBuilder>
implements VisitableBuilder<MachineSetStatus, MachineSetStatusBuilder> {
    MachineSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public MachineSetStatusBuilder() {
        this(false);
    }

    public MachineSetStatusBuilder(Boolean validationEnabled) {
        this(new MachineSetStatus(), validationEnabled);
    }

    public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MachineSetStatus(), validationEnabled);
    }

    public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent, MachineSetStatus instance) {
        this(fluent, instance, false);
    }

    public MachineSetStatusBuilder(MachineSetStatusFluent<?> fluent, MachineSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withErrorMessage(instance.getErrorMessage());
        fluent.withErrorReason(instance.getErrorReason());
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public MachineSetStatusBuilder(MachineSetStatus instance) {
        this(instance, (Boolean)false);
    }

    public MachineSetStatusBuilder(MachineSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withErrorMessage(instance.getErrorMessage());
        this.withErrorReason(instance.getErrorReason());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public MachineSetStatus build() {
        MachineSetStatus buildable = new MachineSetStatus(this.fluent.getAvailableReplicas(), this.fluent.getErrorMessage(), this.fluent.getErrorReason(), this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineSetStatusBuilder that = (MachineSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

