/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.openshift.api.model.v5_8.ComponentRouteStatus;
import io.fabric8.openshift.api.model.v5_8.ComponentRouteStatusBuilder;
import io.fabric8.openshift.api.model.v5_8.ComponentRouteStatusFluentImpl;
import io.fabric8.openshift.api.model.v5_8.IngressStatus;
import io.fabric8.openshift.api.model.v5_8.IngressStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressStatusFluentImpl<A extends IngressStatusFluent<A>>
extends BaseFluent<A>
implements IngressStatusFluent<A> {
    private List<ComponentRouteStatusBuilder> componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();

    public IngressStatusFluentImpl() {
    }

    public IngressStatusFluentImpl(IngressStatus instance) {
        this.withComponentRoutes(instance.getComponentRoutes());
    }

    @Override
    public A addToComponentRoutes(Integer index, ComponentRouteStatus item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
        }
        ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
        this._visitables.get("componentRoutes").add(index >= 0 ? index.intValue() : this._visitables.get("componentRoutes").size(), builder);
        this.componentRoutes.add(index >= 0 ? index.intValue() : this.componentRoutes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToComponentRoutes(Integer index, ComponentRouteStatus item) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
        }
        ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("componentRoutes").size()) {
            this._visitables.get("componentRoutes").add(builder);
        } else {
            this._visitables.get("componentRoutes").set(index, builder);
        }
        if (index < 0 || index >= this.componentRoutes.size()) {
            this.componentRoutes.add(builder);
        } else {
            this.componentRoutes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToComponentRoutes(ComponentRouteStatus ... items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get("componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToComponentRoutes(Collection<ComponentRouteStatus> items) {
        if (this.componentRoutes == null) {
            this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
        }
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get("componentRoutes").add(builder);
            this.componentRoutes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromComponentRoutes(ComponentRouteStatus ... items) {
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get("componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromComponentRoutes(Collection<ComponentRouteStatus> items) {
        for (ComponentRouteStatus item : items) {
            ComponentRouteStatusBuilder builder = new ComponentRouteStatusBuilder(item);
            this._visitables.get("componentRoutes").remove(builder);
            if (this.componentRoutes == null) continue;
            this.componentRoutes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromComponentRoutes(Predicate<ComponentRouteStatusBuilder> predicate) {
        if (this.componentRoutes == null) {
            return (A)this;
        }
        Iterator<ComponentRouteStatusBuilder> each = this.componentRoutes.iterator();
        Object visitables = this._visitables.get("componentRoutes");
        while (each.hasNext()) {
            ComponentRouteStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComponentRouteStatus> getComponentRoutes() {
        return IngressStatusFluentImpl.build(this.componentRoutes);
    }

    @Override
    public List<ComponentRouteStatus> buildComponentRoutes() {
        return IngressStatusFluentImpl.build(this.componentRoutes);
    }

    @Override
    public ComponentRouteStatus buildComponentRoute(Integer index) {
        return this.componentRoutes.get(index).build();
    }

    @Override
    public ComponentRouteStatus buildFirstComponentRoute() {
        return this.componentRoutes.get(0).build();
    }

    @Override
    public ComponentRouteStatus buildLastComponentRoute() {
        return this.componentRoutes.get(this.componentRoutes.size() - 1).build();
    }

    @Override
    public ComponentRouteStatus buildMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        for (ComponentRouteStatusBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        for (ComponentRouteStatusBuilder item : this.componentRoutes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withComponentRoutes(List<ComponentRouteStatus> componentRoutes) {
        if (this.componentRoutes != null) {
            this._visitables.get("componentRoutes").removeAll(this.componentRoutes);
        }
        if (componentRoutes != null) {
            this.componentRoutes = new ArrayList<ComponentRouteStatusBuilder>();
            for (ComponentRouteStatus item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        } else {
            this.componentRoutes = null;
        }
        return (A)this;
    }

    @Override
    public A withComponentRoutes(ComponentRouteStatus ... componentRoutes) {
        if (this.componentRoutes != null) {
            this.componentRoutes.clear();
        }
        if (componentRoutes != null) {
            for (ComponentRouteStatus item : componentRoutes) {
                this.addToComponentRoutes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasComponentRoutes() {
        return this.componentRoutes != null && !this.componentRoutes.isEmpty();
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> addNewComponentRoute() {
        return new ComponentRoutesNestedImpl();
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> addNewComponentRouteLike(ComponentRouteStatus item) {
        return new ComponentRoutesNestedImpl(-1, item);
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> setNewComponentRouteLike(Integer index, ComponentRouteStatus item) {
        return new ComponentRoutesNestedImpl(index, item);
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> editComponentRoute(Integer index) {
        if (this.componentRoutes.size() <= index) {
            throw new RuntimeException("Can't edit componentRoutes. Index exceeds size.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> editFirstComponentRoute() {
        if (this.componentRoutes.size() == 0) {
            throw new RuntimeException("Can't edit first componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(0, this.buildComponentRoute(0));
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> editLastComponentRoute() {
        int index = this.componentRoutes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last componentRoutes. The list is empty.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    @Override
    public IngressStatusFluent.ComponentRoutesNested<A> editMatchingComponentRoute(Predicate<ComponentRouteStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.componentRoutes.size(); ++i) {
            if (!predicate.test(this.componentRoutes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching componentRoutes. No match found.");
        }
        return this.setNewComponentRouteLike(index, this.buildComponentRoute(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressStatusFluentImpl that = (IngressStatusFluentImpl)o;
        return !(this.componentRoutes != null ? !this.componentRoutes.equals(that.componentRoutes) : that.componentRoutes != null);
    }

    public int hashCode() {
        return Objects.hash(this.componentRoutes, super.hashCode());
    }

    public class ComponentRoutesNestedImpl<N>
    extends ComponentRouteStatusFluentImpl<IngressStatusFluent.ComponentRoutesNested<N>>
    implements IngressStatusFluent.ComponentRoutesNested<N>,
    Nested<N> {
        ComponentRouteStatusBuilder builder;
        Integer index;

        ComponentRoutesNestedImpl(Integer index, ComponentRouteStatus item) {
            this.index = index;
            this.builder = new ComponentRouteStatusBuilder(this, item);
        }

        ComponentRoutesNestedImpl() {
            this.index = -1;
            this.builder = new ComponentRouteStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressStatusFluentImpl.this.setToComponentRoutes(this.index, this.builder.build());
        }

        @Override
        public N endComponentRoute() {
            return this.and();
        }
    }
}

