/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_8.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.v5_8.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.v5_8.DeploymentConfigSpecFluentImpl;
import java.util.Objects;

public class DeploymentConfigSpecBuilder
extends DeploymentConfigSpecFluentImpl<DeploymentConfigSpecBuilder>
implements VisitableBuilder<DeploymentConfigSpec, DeploymentConfigSpecBuilder> {
    DeploymentConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigSpecBuilder() {
        this(false);
    }

    public DeploymentConfigSpecBuilder(Boolean validationEnabled) {
        this(new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfigSpec(), validationEnabled);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, DeploymentConfigSpec instance) {
        this(fluent, instance, false);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpecFluent<?> fluent, DeploymentConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withPaused(instance.getPaused());
        fluent.withReplicas(instance.getReplicas());
        fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        fluent.withSelector(instance.getSelector());
        fluent.withStrategy(instance.getStrategy());
        fluent.withTemplate(instance.getTemplate());
        fluent.withTest(instance.getTest());
        fluent.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance) {
        this(instance, (Boolean)false);
    }

    public DeploymentConfigSpecBuilder(DeploymentConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public DeploymentConfigSpec build() {
        DeploymentConfigSpec buildable = new DeploymentConfigSpec(this.fluent.getMinReadySeconds(), this.fluent.getPaused(), this.fluent.getReplicas(), this.fluent.getRevisionHistoryLimit(), this.fluent.getSelector(), this.fluent.getStrategy(), this.fluent.getTemplate(), this.fluent.getTest(), this.fluent.getTriggers());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigSpecBuilder that = (DeploymentConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

