/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8.utils;

import io.fabric8.kubernetes.clnt.v5_8.Config;
import io.fabric8.kubernetes.clnt.v5_8.utils.OpenIDConnectionUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class TokenRefreshInterceptor
implements Interceptor {
    private final Config config;

    public TokenRefreshInterceptor(Config config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (response.code() == 401) {
            Config newestConfig;
            String currentContextName = null;
            String newAccessToken = null;
            if (this.config.getCurrentContext() != null) {
                currentContextName = this.config.getCurrentContext().getName();
            }
            if ((newAccessToken = (newestConfig = Config.autoConfigure(currentContextName)).getAuthProvider() != null && newestConfig.getAuthProvider().getName().equalsIgnoreCase("oidc") ? OpenIDConnectionUtils.resolveOIDCTokenFromAuthConfig(newestConfig.getAuthProvider().getConfig()) : newestConfig.getOauthToken()) != null) {
                response.close();
                Request authReqWithUpdatedToken = chain.request().newBuilder().header("Authorization", "Bearer " + newAccessToken).build();
                this.config.setOauthToken(newAccessToken);
                response = chain.proceed(authReqWithUpdatedToken);
            }
        }
        return response;
    }
}

