/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8.utils;

import io.fabric8.kubernetes.api.model.v5_8.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Resource;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAndCreateHelper<T extends HasMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteAndCreateHelper.class);
    private static final int MAX_WAIT_SECONDS = 30;
    private final UnaryOperator<T> createTask;
    private final Function<T, Boolean> awaitDeleteTask;
    private final Function<T, Boolean> deleteTask;

    public DeleteAndCreateHelper(UnaryOperator<T> createTask, Function<T, Boolean> deleteTask, Function<T, Boolean> awaitDeleteTask) {
        this.createTask = createTask;
        this.awaitDeleteTask = awaitDeleteTask;
        this.deleteTask = deleteTask;
    }

    public T deleteAndCreate(T item) {
        Boolean deleted = this.deleteTask.apply(item);
        if (!deleted.booleanValue()) {
            LOG.debug("did not delete because item did not exist, continuing to create {}", (Object)item.getMetadata().getName());
        }
        try {
            return (T)((HasMetadata)this.createTask.apply(item));
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 409) {
                if (!deleted.booleanValue()) {
                    LOG.error("there was no item to delete, but received HTTP_CONFLICT response upon creation of item {}", (Object)item.getMetadata().getName(), (Object)e);
                    throw e;
                }
                if (Boolean.FALSE.equals(this.awaitDeleteTask.apply(item))) {
                    throw new KubernetesClientException("Timed out waiting for item to be deleted before recreating: " + item.getMetadata().getName(), e);
                }
                return (T)((HasMetadata)this.createTask.apply(item));
            }
            throw e;
        }
    }

    public static HasMetadata deleteAndCreateItem(HasMetadata meta, Resource<HasMetadata> resource) {
        DeleteAndCreateHelper<HasMetadata> deleteAndCreateHelper = new DeleteAndCreateHelper<HasMetadata>(m -> (HasMetadata)resource.create(m), m -> resource.delete(), DeleteAndCreateHelper.waitUntilDeletedOrInterrupted(resource));
        return deleteAndCreateHelper.deleteAndCreate(meta);
    }

    private static <T extends HasMetadata> Function<T, Boolean> waitUntilDeletedOrInterrupted(Resource<HasMetadata> resource) {
        return m -> resource.waitUntilCondition(Objects::isNull, 30L, TimeUnit.SECONDS) == null;
    }
}

