/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_8.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.v5_8.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_8.KubernetesResource;
import io.fabric8.kubernetes.api.model.v5_8.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_8.Config;
import io.fabric8.kubernetes.clnt.v5_8.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_8.internal.KubernetesDeserializer;
import io.fabric8.kubernetes.clnt.v5_8.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v5_8.utils.KubernetesResourceUtil;
import okhttp3.OkHttpClient;

public class HasMetadataOperationsImpl<T extends HasMetadata, L extends KubernetesResourceList<T>>
extends HasMetadataOperation<T, L, Resource<T>>
implements MixedOperation<T, L, Resource<T>> {
    private final ResourceDefinitionContext rdc;

    public HasMetadataOperationsImpl(OkHttpClient client, Config config, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        this(HasMetadataOperationsImpl.defaultContext(new OperationContext(), client, config), rdc, type, listType);
    }

    public static OperationContext defaultContext(OperationContext context, OkHttpClient client, Config config) {
        return context.withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY);
    }

    public HasMetadataOperationsImpl(OperationContext context, ResourceDefinitionContext rdc, Class<T> type, Class<L> listType) {
        super(context.withApiGroupName(rdc.getGroup()).withApiGroupVersion(rdc.getVersion()).withPlural(rdc.getPlural()), type, listType != null ? listType : KubernetesResourceUtil.inferListType(type));
        this.rdc = rdc;
        this.apiGroupName = rdc.getGroup();
        this.apiGroupVersion = rdc.getVersion();
        this.apiVersion = ApiVersionUtil.joinApiGroupAndVersion(this.getAPIGroupName(), this.getAPIGroupVersion());
        if (!GenericKubernetesResource.class.isAssignableFrom(type)) {
            KubernetesDeserializer.registerCustomKind(this.apiVersion, this.kind(rdc), type);
            if (KubernetesResource.class.isAssignableFrom(this.listType)) {
                KubernetesDeserializer.registerCustomKind(this.listType.getSimpleName(), this.listType);
            }
        }
    }

    @Override
    protected void validateOperation(Class<T> type) {
    }

    public HasMetadataOperationsImpl<T, L> newInstance(OperationContext context) {
        return new HasMetadataOperationsImpl<T, L>(context, this.rdc, this.type, this.listType);
    }

    private String kind(ResourceDefinitionContext context) {
        return context.getKind() != null ? context.getKind() : this.getKind();
    }

    @Override
    public boolean isResourceNamespaced() {
        return this.rdc.isNamespaceScoped();
    }

    public OperationContext getOperationContext() {
        return this.context;
    }
}

