/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_8.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_8.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_8.ListOptions;
import io.fabric8.kubernetes.clnt.v5_8.Config;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_8.utils.HttpClientUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Request;

class BaseOperationRequestBuilder<T extends HasMetadata, L extends KubernetesResourceList<T>> {
    private final URL requestUrl;
    private final BaseOperation<T, L, ?> baseOperation;
    private final ListOptions listOptions;

    public BaseOperationRequestBuilder(BaseOperation<T, L, ?> baseOperation, ListOptions listOptions) throws MalformedURLException {
        this.baseOperation = baseOperation;
        this.requestUrl = baseOperation.getNamespacedUrl();
        this.listOptions = listOptions;
    }

    public BaseOperation<T, L, ?> getBaseOperation() {
        return this.baseOperation;
    }

    public Request build(String resourceVersion) {
        Map<String, String> customHeaders;
        HttpUrl.Builder httpUrlBuilder = HttpUrl.get((URL)this.requestUrl).newBuilder();
        this.listOptions.setResourceVersion(resourceVersion);
        HttpClientUtils.appendListOptionParams(httpUrlBuilder, this.listOptions);
        String origin = this.requestUrl.getProtocol() + "://" + this.requestUrl.getHost();
        if (this.requestUrl.getPort() != -1) {
            origin = origin + ":" + this.requestUrl.getPort();
        }
        Request.Builder requestBuilder = new Request.Builder().get().url(httpUrlBuilder.build()).addHeader("Origin", origin);
        Config config = this.baseOperation.getConfig();
        if (Objects.nonNull(config) && Objects.nonNull(customHeaders = config.getCustomHeaders()) && !customHeaders.isEmpty()) {
            for (String key : customHeaders.keySet()) {
                requestBuilder.addHeader(key, customHeaders.get(key));
            }
        }
        return requestBuilder.build();
    }
}

