/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8;

import io.fabric8.kubernetes.api.model.v5_8.RootPaths;
import io.fabric8.kubernetes.clnt.v5_8.Client;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentMap;

public abstract class ExtensionAdapterSupport {
    protected Boolean isAdaptable(Client client, ConcurrentMap<URL, Boolean> isApi, ConcurrentMap<URL, Boolean> usesApiGroups, String apiGroup) {
        List<String> paths;
        URL masterUrl = client.getMasterUrl();
        if (isApi.containsKey(masterUrl)) {
            return (Boolean)isApi.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith(apiGroup) && !path.contains(apiGroup + "/")) continue;
                usesApiGroups.putIfAbsent(masterUrl, true);
                isApi.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        isApi.putIfAbsent(masterUrl, false);
        return false;
    }
}

