/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_8.networking.v1.NetworkPolicySpec;
import io.fabric8.kubernetes.api.model.v5_8.networking.v1.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.api.model.v5_8.networking.v1.NetworkPolicySpecFluentImpl;
import java.util.Objects;

public class NetworkPolicySpecBuilder
extends NetworkPolicySpecFluentImpl<NetworkPolicySpecBuilder>
implements VisitableBuilder<NetworkPolicySpec, NetworkPolicySpecBuilder> {
    NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicySpecBuilder() {
        this(false);
    }

    public NetworkPolicySpecBuilder(Boolean validationEnabled) {
        this(new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance) {
        this(fluent, instance, false);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEgress(instance.getEgress());
        fluent.withIngress(instance.getIngress());
        fluent.withPodSelector(instance.getPodSelector());
        fluent.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance) {
        this(instance, (Boolean)false);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicySpec build() {
        NetworkPolicySpec buildable = new NetworkPolicySpec(this.fluent.getEgress(), this.fluent.getIngress(), this.fluent.getPodSelector(), this.fluent.getPolicyTypes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicySpecBuilder that = (NetworkPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

