/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_8.Service;
import io.fabric8.kubernetes.api.model.v5_8.ServiceFluent;
import io.fabric8.kubernetes.api.model.v5_8.ServiceFluentImpl;
import java.util.Objects;

public class ServiceBuilder
extends ServiceFluentImpl<ServiceBuilder>
implements VisitableBuilder<Service, ServiceBuilder> {
    ServiceFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceBuilder() {
        this(false);
    }

    public ServiceBuilder(Boolean validationEnabled) {
        this(new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Service(), validationEnabled);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance) {
        this(fluent, instance, false);
    }

    public ServiceBuilder(ServiceFluent<?> fluent, Service instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ServiceBuilder(Service instance) {
        this(instance, (Boolean)false);
    }

    public ServiceBuilder(Service instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Service build() {
        Service buildable = new Service(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceBuilder that = (ServiceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

