/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_8.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.v5_8.ReplicationControllerSpecFluent;
import io.fabric8.kubernetes.api.model.v5_8.ReplicationControllerSpecFluentImpl;
import java.util.Objects;

public class ReplicationControllerSpecBuilder
extends ReplicationControllerSpecFluentImpl<ReplicationControllerSpecBuilder>
implements VisitableBuilder<ReplicationControllerSpec, ReplicationControllerSpecBuilder> {
    ReplicationControllerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicationControllerSpecBuilder() {
        this(false);
    }

    public ReplicationControllerSpecBuilder(Boolean validationEnabled) {
        this(new ReplicationControllerSpec(), validationEnabled);
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicationControllerSpec(), validationEnabled);
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent, ReplicationControllerSpec instance) {
        this(fluent, instance, false);
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpecFluent<?> fluent, ReplicationControllerSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMinReadySeconds(instance.getMinReadySeconds());
        fluent.withReplicas(instance.getReplicas());
        fluent.withSelector(instance.getSelector());
        fluent.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance) {
        this(instance, (Boolean)false);
    }

    public ReplicationControllerSpecBuilder(ReplicationControllerSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicationControllerSpec build() {
        ReplicationControllerSpec buildable = new ReplicationControllerSpec(this.fluent.getMinReadySeconds(), this.fluent.getReplicas(), this.fluent.getSelector(), this.fluent.getTemplate());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerSpecBuilder that = (ReplicationControllerSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

