/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.kubernetes.api.model.v5_8.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_8.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_8.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeStatus;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeStatusBuilder;
import io.fabric8.kubernetes.api.model.v5_8.PersistentVolumeStatusFluentImpl;
import java.util.Objects;

public class PersistentVolumeFluentImpl<A extends PersistentVolumeFluent<A>>
extends BaseFluent<A>
implements PersistentVolumeFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PersistentVolumeSpecBuilder spec;
    private PersistentVolumeStatusBuilder status;

    public PersistentVolumeFluentImpl() {
    }

    public PersistentVolumeFluentImpl(PersistentVolume instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public PersistentVolumeSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public PersistentVolumeSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(PersistentVolumeSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new PersistentVolumeSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> withNewSpecLike(PersistentVolumeSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new PersistentVolumeSpecBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.SpecNested<A> editOrNewSpecLike(PersistentVolumeSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public PersistentVolumeStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public PersistentVolumeStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(PersistentVolumeStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new PersistentVolumeStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(String message, String phase, String reason) {
        return this.withStatus(new PersistentVolumeStatus(message, phase, reason));
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> withNewStatusLike(PersistentVolumeStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new PersistentVolumeStatusBuilder().build());
    }

    @Override
    public PersistentVolumeFluent.StatusNested<A> editOrNewStatusLike(PersistentVolumeStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeFluentImpl that = (PersistentVolumeFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends PersistentVolumeStatusFluentImpl<PersistentVolumeFluent.StatusNested<N>>
    implements PersistentVolumeFluent.StatusNested<N>,
    Nested<N> {
        PersistentVolumeStatusBuilder builder;

        StatusNestedImpl(PersistentVolumeStatus item) {
            this.builder = new PersistentVolumeStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PersistentVolumeStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PersistentVolumeSpecFluentImpl<PersistentVolumeFluent.SpecNested<N>>
    implements PersistentVolumeFluent.SpecNested<N>,
    Nested<N> {
        PersistentVolumeSpecBuilder builder;

        SpecNestedImpl(PersistentVolumeSpec item) {
            this.builder = new PersistentVolumeSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PersistentVolumeSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PersistentVolumeFluent.MetadataNested<N>>
    implements PersistentVolumeFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

