/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluent;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointTLSConfigFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodMetricsEndpointFluentImpl<A extends PodMetricsEndpointFluent<A>>
extends BaseFluent<A>
implements PodMetricsEndpointFluent<A> {
    private BasicAuthBuilder basicAuth;
    private SecretKeySelector bearerTokenSecret;
    private Boolean honorLabels;
    private Boolean honorTimestamps;
    private String interval;
    private List<RelabelConfigBuilder> metricRelabelings = new ArrayList<RelabelConfigBuilder>();
    private Map<String, ArrayList<String>> params;
    private String path;
    private String port;
    private String proxyUrl;
    private List<RelabelConfigBuilder> relabelings = new ArrayList<RelabelConfigBuilder>();
    private String scheme;
    private String scrapeTimeout;
    private IntOrStringBuilder targetPort;
    private PodMetricsEndpointTLSConfigBuilder tlsConfig;

    public PodMetricsEndpointFluentImpl() {
    }

    public PodMetricsEndpointFluentImpl(PodMetricsEndpoint instance) {
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerTokenSecret(instance.getBearerTokenSecret());
        this.withHonorLabels(instance.getHonorLabels());
        this.withHonorTimestamps(instance.getHonorTimestamps());
        this.withInterval(instance.getInterval());
        this.withMetricRelabelings(instance.getMetricRelabelings());
        this.withParams(instance.getParams());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withProxyUrl(instance.getProxyUrl());
        this.withRelabelings(instance.getRelabelings());
        this.withScheme(instance.getScheme());
        this.withScrapeTimeout(instance.getScrapeTimeout());
        this.withTargetPort(instance.getTargetPort());
        this.withTlsConfig(instance.getTlsConfig());
    }

    @Override
    @Deprecated
    public BasicAuth getBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    @Override
    public PodMetricsEndpointFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    @Override
    public PodMetricsEndpointFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    @Override
    public PodMetricsEndpointFluent.BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth());
    }

    @Override
    public PodMetricsEndpointFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : new BasicAuthBuilder().build());
    }

    @Override
    public PodMetricsEndpointFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : item);
    }

    @Override
    public SecretKeySelector getBearerTokenSecret() {
        return this.bearerTokenSecret;
    }

    @Override
    public A withBearerTokenSecret(SecretKeySelector bearerTokenSecret) {
        this.bearerTokenSecret = bearerTokenSecret;
        return (A)this;
    }

    @Override
    public Boolean hasBearerTokenSecret() {
        return this.bearerTokenSecret != null;
    }

    @Override
    public A withNewBearerTokenSecret(String key, String name, Boolean optional) {
        return this.withBearerTokenSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public Boolean getHonorLabels() {
        return this.honorLabels;
    }

    @Override
    public A withHonorLabels(Boolean honorLabels) {
        this.honorLabels = honorLabels;
        return (A)this;
    }

    @Override
    public Boolean hasHonorLabels() {
        return this.honorLabels != null;
    }

    @Override
    public Boolean getHonorTimestamps() {
        return this.honorTimestamps;
    }

    @Override
    public A withHonorTimestamps(Boolean honorTimestamps) {
        this.honorTimestamps = honorTimestamps;
        return (A)this;
    }

    @Override
    public Boolean hasHonorTimestamps() {
        return this.honorTimestamps != null;
    }

    @Override
    public String getInterval() {
        return this.interval;
    }

    @Override
    public A withInterval(String interval) {
        this.interval = interval;
        return (A)this;
    }

    @Override
    public Boolean hasInterval() {
        return this.interval != null;
    }

    @Override
    @Deprecated
    public A withNewInterval(String arg0) {
        return this.withInterval(new String(arg0));
    }

    @Override
    public A addToMetricRelabelings(Integer index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        this._visitables.get("metricRelabelings").add(index >= 0 ? index.intValue() : this._visitables.get("metricRelabelings").size(), builder);
        this.metricRelabelings.add(index >= 0 ? index.intValue() : this.metricRelabelings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMetricRelabelings(Integer index, RelabelConfig item) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get("metricRelabelings").size()) {
            this._visitables.get("metricRelabelings").add(builder);
        } else {
            this._visitables.get("metricRelabelings").set(index, builder);
        }
        if (index < 0 || index >= this.metricRelabelings.size()) {
            this.metricRelabelings.add(builder);
        } else {
            this.metricRelabelings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMetricRelabelings(RelabelConfig ... items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMetricRelabelings(Collection<RelabelConfig> items) {
        if (this.metricRelabelings == null) {
            this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").add(builder);
            this.metricRelabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMetricRelabelings(RelabelConfig ... items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").remove(builder);
            if (this.metricRelabelings == null) continue;
            this.metricRelabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMetricRelabelings(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("metricRelabelings").remove(builder);
            if (this.metricRelabelings == null) continue;
            this.metricRelabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMetricRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.metricRelabelings == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.metricRelabelings.iterator();
        Object visitables = this._visitables.get("metricRelabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RelabelConfig> getMetricRelabelings() {
        return PodMetricsEndpointFluentImpl.build(this.metricRelabelings);
    }

    @Override
    public List<RelabelConfig> buildMetricRelabelings() {
        return PodMetricsEndpointFluentImpl.build(this.metricRelabelings);
    }

    @Override
    public RelabelConfig buildMetricRelabeling(Integer index) {
        return this.metricRelabelings.get(index).build();
    }

    @Override
    public RelabelConfig buildFirstMetricRelabeling() {
        return this.metricRelabelings.get(0).build();
    }

    @Override
    public RelabelConfig buildLastMetricRelabeling() {
        return this.metricRelabelings.get(this.metricRelabelings.size() - 1).build();
    }

    @Override
    public RelabelConfig buildMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.metricRelabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMetricRelabelings(List<RelabelConfig> metricRelabelings) {
        if (this.metricRelabelings != null) {
            this._visitables.get("metricRelabelings").removeAll(this.metricRelabelings);
        }
        if (metricRelabelings != null) {
            this.metricRelabelings = new ArrayList<RelabelConfigBuilder>();
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        } else {
            this.metricRelabelings = null;
        }
        return (A)this;
    }

    @Override
    public A withMetricRelabelings(RelabelConfig ... metricRelabelings) {
        if (this.metricRelabelings != null) {
            this.metricRelabelings.clear();
        }
        if (metricRelabelings != null) {
            for (RelabelConfig item : metricRelabelings) {
                this.addToMetricRelabelings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricRelabelings() {
        return this.metricRelabelings != null && !this.metricRelabelings.isEmpty();
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabeling() {
        return new MetricRelabelingsNestedImpl();
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> addNewMetricRelabelingLike(RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(-1, item);
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> setNewMetricRelabelingLike(Integer index, RelabelConfig item) {
        return new MetricRelabelingsNestedImpl(index, item);
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMetricRelabeling(Integer index) {
        if (this.metricRelabelings.size() <= index) {
            throw new RuntimeException("Can't edit metricRelabelings. Index exceeds size.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editFirstMetricRelabeling() {
        if (this.metricRelabelings.size() == 0) {
            throw new RuntimeException("Can't edit first metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(0, this.buildMetricRelabeling(0));
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editLastMetricRelabeling() {
        int index = this.metricRelabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last metricRelabelings. The list is empty.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public PodMetricsEndpointFluent.MetricRelabelingsNested<A> editMatchingMetricRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.metricRelabelings.size(); ++i) {
            if (!predicate.test(this.metricRelabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching metricRelabelings. No match found.");
        }
        return this.setNewMetricRelabelingLike(index, this.buildMetricRelabeling(index));
    }

    @Override
    public A addToParams(String key, ArrayList<String> value) {
        if (this.params == null && key != null && value != null) {
            this.params = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.params.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToParams(Map<String, ArrayList<String>> map) {
        if (this.params == null && map != null) {
            this.params = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.params.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromParams(String key) {
        if (this.params == null) {
            return (A)this;
        }
        if (key != null && this.params != null) {
            this.params.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromParams(Map<String, ArrayList<String>> map) {
        if (this.params == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.params == null) continue;
                this.params.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getParams() {
        return this.params;
    }

    @Override
    public <K, V> A withParams(Map<String, ArrayList<String>> params) {
        this.params = params == null ? null : new LinkedHashMap<String, ArrayList<String>>(params);
        return (A)this;
    }

    @Override
    public Boolean hasParams() {
        return this.params != null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public A withPort(String port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    @Deprecated
    public A withNewPort(String arg0) {
        return this.withPort(new String(arg0));
    }

    @Override
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Override
    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    @Override
    public Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    @Override
    @Deprecated
    public A withNewProxyUrl(String arg0) {
        return this.withProxyUrl(new String(arg0));
    }

    @Override
    public A addToRelabelings(Integer index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        this._visitables.get("relabelings").add(index >= 0 ? index.intValue() : this._visitables.get("relabelings").size(), builder);
        this.relabelings.add(index >= 0 ? index.intValue() : this.relabelings.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRelabelings(Integer index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList<RelabelConfigBuilder>();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this._visitables.get("relabelings").size()) {
            this._visitables.get("relabelings").add(builder);
        } else {
            this._visitables.get("relabelings").set(index, builder);
        }
        if (index < 0 || index >= this.relabelings.size()) {
            this.relabelings.add(builder);
        } else {
            this.relabelings.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRelabelings(RelabelConfig ... items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList<RelabelConfigBuilder>();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRelabelings(RelabelConfig ... items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("relabelings").remove(builder);
            if (this.relabelings == null) continue;
            this.relabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get("relabelings").remove(builder);
            if (this.relabelings == null) continue;
            this.relabelings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelings == null) {
            return (A)this;
        }
        Iterator<RelabelConfigBuilder> each = this.relabelings.iterator();
        Object visitables = this._visitables.get("relabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RelabelConfig> getRelabelings() {
        return PodMetricsEndpointFluentImpl.build(this.relabelings);
    }

    @Override
    public List<RelabelConfig> buildRelabelings() {
        return PodMetricsEndpointFluentImpl.build(this.relabelings);
    }

    @Override
    public RelabelConfig buildRelabeling(Integer index) {
        return this.relabelings.get(index).build();
    }

    @Override
    public RelabelConfig buildFirstRelabeling() {
        return this.relabelings.get(0).build();
    }

    @Override
    public RelabelConfig buildLastRelabeling() {
        return this.relabelings.get(this.relabelings.size() - 1).build();
    }

    @Override
    public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRelabelings(List<RelabelConfig> relabelings) {
        if (this.relabelings != null) {
            this._visitables.get("relabelings").removeAll(this.relabelings);
        }
        if (relabelings != null) {
            this.relabelings = new ArrayList<RelabelConfigBuilder>();
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        } else {
            this.relabelings = null;
        }
        return (A)this;
    }

    @Override
    public A withRelabelings(RelabelConfig ... relabelings) {
        if (this.relabelings != null) {
            this.relabelings.clear();
        }
        if (relabelings != null) {
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRelabelings() {
        return this.relabelings != null && !this.relabelings.isEmpty();
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabeling() {
        return new RelabelingsNestedImpl();
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
        return new RelabelingsNestedImpl(-1, item);
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> setNewRelabelingLike(Integer index, RelabelConfig item) {
        return new RelabelingsNestedImpl(index, item);
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> editRelabeling(Integer index) {
        if (this.relabelings.size() <= index) {
            throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> editFirstRelabeling() {
        if (this.relabelings.size() == 0) {
            throw new RuntimeException("Can't edit first relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(0, this.buildRelabeling(0));
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> editLastRelabeling() {
        int index = this.relabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    @Override
    public PodMetricsEndpointFluent.RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelings.size(); ++i) {
            if (!predicate.test(this.relabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relabelings. No match found.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    @Deprecated
    public A withNewScheme(String arg0) {
        return this.withScheme(new String(arg0));
    }

    @Override
    public String getScrapeTimeout() {
        return this.scrapeTimeout;
    }

    @Override
    public A withScrapeTimeout(String scrapeTimeout) {
        this.scrapeTimeout = scrapeTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasScrapeTimeout() {
        return this.scrapeTimeout != null;
    }

    @Override
    @Deprecated
    public A withNewScrapeTimeout(String arg0) {
        return this.withScrapeTimeout(new String(arg0));
    }

    @Override
    @Deprecated
    public IntOrString getTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public IntOrString buildTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public A withTargetPort(IntOrString targetPort) {
        this._visitables.get("targetPort").remove(this.targetPort);
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.get("targetPort").add(this.targetPort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    @Override
    public A withNewTargetPort(Integer intVal) {
        return this.withTargetPort(new IntOrString(intVal));
    }

    @Override
    public A withNewTargetPort(String strVal) {
        return this.withTargetPort(new IntOrString(strVal));
    }

    @Override
    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNestedImpl();
    }

    @Override
    public PodMetricsEndpointFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNestedImpl(item);
    }

    @Override
    public PodMetricsEndpointFluent.TargetPortNested<A> editTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort());
    }

    @Override
    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : new IntOrStringBuilder().build());
    }

    @Override
    public PodMetricsEndpointFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : item);
    }

    @Override
    @Deprecated
    public PodMetricsEndpointTLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public PodMetricsEndpointTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(PodMetricsEndpointTLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new PodMetricsEndpointTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public PodMetricsEndpointFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public PodMetricsEndpointFluent.TlsConfigNested<A> withNewTlsConfigLike(PodMetricsEndpointTLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public PodMetricsEndpointFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public PodMetricsEndpointFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new PodMetricsEndpointTLSConfigBuilder().build());
    }

    @Override
    public PodMetricsEndpointFluent.TlsConfigNested<A> editOrNewTlsConfigLike(PodMetricsEndpointTLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodMetricsEndpointFluentImpl that = (PodMetricsEndpointFluentImpl)o;
        if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) {
            return false;
        }
        if (this.bearerTokenSecret != null ? !this.bearerTokenSecret.equals(that.bearerTokenSecret) : that.bearerTokenSecret != null) {
            return false;
        }
        if (this.honorLabels != null ? !this.honorLabels.equals(that.honorLabels) : that.honorLabels != null) {
            return false;
        }
        if (this.honorTimestamps != null ? !this.honorTimestamps.equals(that.honorTimestamps) : that.honorTimestamps != null) {
            return false;
        }
        if (this.interval != null ? !this.interval.equals(that.interval) : that.interval != null) {
            return false;
        }
        if (this.metricRelabelings != null ? !this.metricRelabelings.equals(that.metricRelabelings) : that.metricRelabelings != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(that.params) : that.params != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.proxyUrl != null ? !this.proxyUrl.equals(that.proxyUrl) : that.proxyUrl != null) {
            return false;
        }
        if (this.relabelings != null ? !this.relabelings.equals(that.relabelings) : that.relabelings != null) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.scrapeTimeout != null ? !this.scrapeTimeout.equals(that.scrapeTimeout) : that.scrapeTimeout != null) {
            return false;
        }
        if (this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null) {
            return false;
        }
        return !(this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null);
    }

    public int hashCode() {
        return Objects.hash(this.basicAuth, this.bearerTokenSecret, this.honorLabels, this.honorTimestamps, this.interval, this.metricRelabelings, this.params, this.path, this.port, this.proxyUrl, this.relabelings, this.scheme, this.scrapeTimeout, this.targetPort, this.tlsConfig, super.hashCode());
    }

    public class TlsConfigNestedImpl<N>
    extends PodMetricsEndpointTLSConfigFluentImpl<PodMetricsEndpointFluent.TlsConfigNested<N>>
    implements PodMetricsEndpointFluent.TlsConfigNested<N>,
    Nested<N> {
        PodMetricsEndpointTLSConfigBuilder builder;

        TlsConfigNestedImpl(PodMetricsEndpointTLSConfig item) {
            this.builder = new PodMetricsEndpointTLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new PodMetricsEndpointTLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsEndpointFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }

    public class TargetPortNestedImpl<N>
    extends IntOrStringFluentImpl<PodMetricsEndpointFluent.TargetPortNested<N>>
    implements PodMetricsEndpointFluent.TargetPortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        TargetPortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        TargetPortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsEndpointFluentImpl.this.withTargetPort(this.builder.build());
        }

        @Override
        public N endTargetPort() {
            return this.and();
        }
    }

    public class RelabelingsNestedImpl<N>
    extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.RelabelingsNested<N>>
    implements PodMetricsEndpointFluent.RelabelingsNested<N>,
    Nested<N> {
        RelabelConfigBuilder builder;
        Integer index;

        RelabelingsNestedImpl(Integer index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        RelabelingsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsEndpointFluentImpl.this.setToRelabelings(this.index, this.builder.build());
        }

        @Override
        public N endRelabeling() {
            return this.and();
        }
    }

    public class MetricRelabelingsNestedImpl<N>
    extends RelabelConfigFluentImpl<PodMetricsEndpointFluent.MetricRelabelingsNested<N>>
    implements PodMetricsEndpointFluent.MetricRelabelingsNested<N>,
    Nested<N> {
        RelabelConfigBuilder builder;
        Integer index;

        MetricRelabelingsNestedImpl(Integer index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        MetricRelabelingsNestedImpl() {
            this.index = -1;
            this.builder = new RelabelConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsEndpointFluentImpl.this.setToMetricRelabelings(this.index, this.builder.build());
        }

        @Override
        public N endMetricRelabeling() {
            return this.and();
        }
    }

    public class BasicAuthNestedImpl<N>
    extends BasicAuthFluentImpl<PodMetricsEndpointFluent.BasicAuthNested<N>>
    implements PodMetricsEndpointFluent.BasicAuthNested<N>,
    Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNestedImpl(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        BasicAuthNestedImpl() {
            this.builder = new BasicAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMetricsEndpointFluentImpl.this.withBasicAuth(this.builder.build());
        }

        @Override
        public N endBasicAuth() {
            return this.and();
        }
    }
}

