/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpec;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluent;
import io.fabric8.openshift.api.model.machineconfig.v1.MachineConfigSpecFluentImpl;
import java.util.Objects;

public class MachineConfigSpecBuilder
extends MachineConfigSpecFluentImpl<MachineConfigSpecBuilder>
implements VisitableBuilder<MachineConfigSpec, MachineConfigSpecBuilder> {
    MachineConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public MachineConfigSpecBuilder() {
        this(false);
    }

    public MachineConfigSpecBuilder(Boolean validationEnabled) {
        this(new MachineConfigSpec(), validationEnabled);
    }

    public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new MachineConfigSpec(), validationEnabled);
    }

    public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent, MachineConfigSpec instance) {
        this(fluent, instance, false);
    }

    public MachineConfigSpecBuilder(MachineConfigSpecFluent<?> fluent, MachineConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withExtensions(instance.getExtensions());
        fluent.withFips(instance.getFips());
        fluent.withKernelArguments(instance.getKernelArguments());
        fluent.withKernelType(instance.getKernelType());
        fluent.withOsImageURL(instance.getOsImageURL());
        this.validationEnabled = validationEnabled;
    }

    public MachineConfigSpecBuilder(MachineConfigSpec instance) {
        this(instance, (Boolean)false);
    }

    public MachineConfigSpecBuilder(MachineConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withExtensions(instance.getExtensions());
        this.withFips(instance.getFips());
        this.withKernelArguments(instance.getKernelArguments());
        this.withKernelType(instance.getKernelType());
        this.withOsImageURL(instance.getOsImageURL());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public MachineConfigSpec build() {
        MachineConfigSpec buildable = new MachineConfigSpec(this.fluent.getConfig(), this.fluent.getExtensions(), this.fluent.getFips(), this.fluent.getKernelArguments(), this.fluent.getKernelType(), this.fluent.getOsImageURL());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigSpecBuilder that = (MachineConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

