/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.InfrastructureStatus;
import io.fabric8.openshift.api.model.InfrastructureStatusFluent;
import io.fabric8.openshift.api.model.PlatformStatus;
import io.fabric8.openshift.api.model.PlatformStatusBuilder;
import io.fabric8.openshift.api.model.PlatformStatusFluentImpl;
import java.util.Objects;

public class InfrastructureStatusFluentImpl<A extends InfrastructureStatusFluent<A>>
extends BaseFluent<A>
implements InfrastructureStatusFluent<A> {
    private String apiServerInternalURI;
    private String apiServerURL;
    private String controlPlaneTopology;
    private String etcdDiscoveryDomain;
    private String infrastructureName;
    private String infrastructureTopology;
    private String platform;
    private PlatformStatusBuilder platformStatus;

    public InfrastructureStatusFluentImpl() {
    }

    public InfrastructureStatusFluentImpl(InfrastructureStatus instance) {
        this.withApiServerInternalURI(instance.getApiServerInternalURI());
        this.withApiServerURL(instance.getApiServerURL());
        this.withControlPlaneTopology(instance.getControlPlaneTopology());
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
        this.withInfrastructureName(instance.getInfrastructureName());
        this.withInfrastructureTopology(instance.getInfrastructureTopology());
        this.withPlatform(instance.getPlatform());
        this.withPlatformStatus(instance.getPlatformStatus());
    }

    @Override
    public String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    @Override
    public A withApiServerInternalURI(String apiServerInternalURI) {
        this.apiServerInternalURI = apiServerInternalURI;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    @Override
    @Deprecated
    public A withNewApiServerInternalURI(String arg0) {
        return this.withApiServerInternalURI(new String(arg0));
    }

    @Override
    public String getApiServerURL() {
        return this.apiServerURL;
    }

    @Override
    public A withApiServerURL(String apiServerURL) {
        this.apiServerURL = apiServerURL;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    @Override
    @Deprecated
    public A withNewApiServerURL(String arg0) {
        return this.withApiServerURL(new String(arg0));
    }

    @Override
    public String getControlPlaneTopology() {
        return this.controlPlaneTopology;
    }

    @Override
    public A withControlPlaneTopology(String controlPlaneTopology) {
        this.controlPlaneTopology = controlPlaneTopology;
        return (A)this;
    }

    @Override
    public Boolean hasControlPlaneTopology() {
        return this.controlPlaneTopology != null;
    }

    @Override
    @Deprecated
    public A withNewControlPlaneTopology(String arg0) {
        return this.withControlPlaneTopology(new String(arg0));
    }

    @Override
    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    @Override
    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain = etcdDiscoveryDomain;
        return (A)this;
    }

    @Override
    public Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    @Override
    @Deprecated
    public A withNewEtcdDiscoveryDomain(String arg0) {
        return this.withEtcdDiscoveryDomain(new String(arg0));
    }

    @Override
    public String getInfrastructureName() {
        return this.infrastructureName;
    }

    @Override
    public A withInfrastructureName(String infrastructureName) {
        this.infrastructureName = infrastructureName;
        return (A)this;
    }

    @Override
    public Boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    @Override
    @Deprecated
    public A withNewInfrastructureName(String arg0) {
        return this.withInfrastructureName(new String(arg0));
    }

    @Override
    public String getInfrastructureTopology() {
        return this.infrastructureTopology;
    }

    @Override
    public A withInfrastructureTopology(String infrastructureTopology) {
        this.infrastructureTopology = infrastructureTopology;
        return (A)this;
    }

    @Override
    public Boolean hasInfrastructureTopology() {
        return this.infrastructureTopology != null;
    }

    @Override
    @Deprecated
    public A withNewInfrastructureTopology(String arg0) {
        return this.withInfrastructureTopology(new String(arg0));
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    @Deprecated
    public A withNewPlatform(String arg0) {
        return this.withPlatform(new String(arg0));
    }

    @Override
    @Deprecated
    public PlatformStatus getPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public A withPlatformStatus(PlatformStatus platformStatus) {
        this._visitables.get("platformStatus").remove(this.platformStatus);
        if (platformStatus != null) {
            this.platformStatus = new PlatformStatusBuilder(platformStatus);
            this._visitables.get("platformStatus").add(this.platformStatus);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNestedImpl();
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNestedImpl(item);
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : new PlatformStatusBuilder().build());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureStatusFluentImpl that = (InfrastructureStatusFluentImpl)o;
        if (this.apiServerInternalURI != null ? !this.apiServerInternalURI.equals(that.apiServerInternalURI) : that.apiServerInternalURI != null) {
            return false;
        }
        if (this.apiServerURL != null ? !this.apiServerURL.equals(that.apiServerURL) : that.apiServerURL != null) {
            return false;
        }
        if (this.controlPlaneTopology != null ? !this.controlPlaneTopology.equals(that.controlPlaneTopology) : that.controlPlaneTopology != null) {
            return false;
        }
        if (this.etcdDiscoveryDomain != null ? !this.etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) : that.etcdDiscoveryDomain != null) {
            return false;
        }
        if (this.infrastructureName != null ? !this.infrastructureName.equals(that.infrastructureName) : that.infrastructureName != null) {
            return false;
        }
        if (this.infrastructureTopology != null ? !this.infrastructureTopology.equals(that.infrastructureTopology) : that.infrastructureTopology != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        return !(this.platformStatus != null ? !this.platformStatus.equals(that.platformStatus) : that.platformStatus != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerInternalURI, this.apiServerURL, this.controlPlaneTopology, this.etcdDiscoveryDomain, this.infrastructureName, this.infrastructureTopology, this.platform, this.platformStatus, super.hashCode());
    }

    public class PlatformStatusNestedImpl<N>
    extends PlatformStatusFluentImpl<InfrastructureStatusFluent.PlatformStatusNested<N>>
    implements InfrastructureStatusFluent.PlatformStatusNested<N>,
    Nested<N> {
        PlatformStatusBuilder builder;

        PlatformStatusNestedImpl(PlatformStatus item) {
            this.builder = new PlatformStatusBuilder(this, item);
        }

        PlatformStatusNestedImpl() {
            this.builder = new PlatformStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)InfrastructureStatusFluentImpl.this.withPlatformStatus(this.builder.build());
        }

        @Override
        public N endPlatformStatus() {
            return this.and();
        }
    }
}

