/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule;
import io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class NonResourcePolicyRuleFluentImpl<A extends NonResourcePolicyRuleFluent<A>>
extends BaseFluent<A>
implements NonResourcePolicyRuleFluent<A> {
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public NonResourcePolicyRuleFluentImpl() {
    }

    public NonResourcePolicyRuleFluentImpl(NonResourcePolicyRule instance) {
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNonResourceURLs(String ... items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNonResourceURLs(Collection<String> items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    @Override
    public String getNonResourceURL(Integer index) {
        return this.nonResourceURLs.get(index);
    }

    @Override
    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    @Override
    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    @Override
    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    @Override
    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    @Override
    public A addNewNonResourceURL(String arg0) {
        return this.addToNonResourceURLs(new String(arg0));
    }

    @Override
    public A addToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(Integer index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public A addNewVerb(String arg0) {
        return this.addToVerbs(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NonResourcePolicyRuleFluentImpl that = (NonResourcePolicyRuleFluentImpl)o;
        if (this.nonResourceURLs != null ? !this.nonResourceURLs.equals(that.nonResourceURLs) : that.nonResourceURLs != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }

    public int hashCode() {
        return Objects.hash(this.nonResourceURLs, this.verbs, super.hashCode());
    }
}

