/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_8;

import io.fabric8.kubernetes.clnt.v5_8.BaseClient;
import io.fabric8.kubernetes.clnt.v5_8.Config;
import io.fabric8.kubernetes.clnt.v5_8.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Resource;
import io.fabric8.openshift.api.model.v5_8.APIServer;
import io.fabric8.openshift.api.model.v5_8.APIServerList;
import io.fabric8.openshift.api.model.v5_8.Authentication;
import io.fabric8.openshift.api.model.v5_8.AuthenticationList;
import io.fabric8.openshift.api.model.v5_8.ClusterOperator;
import io.fabric8.openshift.api.model.v5_8.ClusterOperatorList;
import io.fabric8.openshift.api.model.v5_8.ClusterVersion;
import io.fabric8.openshift.api.model.v5_8.ClusterVersionList;
import io.fabric8.openshift.api.model.v5_8.Console;
import io.fabric8.openshift.api.model.v5_8.ConsoleList;
import io.fabric8.openshift.api.model.v5_8.DNS;
import io.fabric8.openshift.api.model.v5_8.DNSList;
import io.fabric8.openshift.api.model.v5_8.FeatureGate;
import io.fabric8.openshift.api.model.v5_8.FeatureGateList;
import io.fabric8.openshift.api.model.v5_8.Infrastructure;
import io.fabric8.openshift.api.model.v5_8.InfrastructureList;
import io.fabric8.openshift.api.model.v5_8.Ingress;
import io.fabric8.openshift.api.model.v5_8.IngressList;
import io.fabric8.openshift.api.model.v5_8.Network;
import io.fabric8.openshift.api.model.v5_8.NetworkList;
import io.fabric8.openshift.api.model.v5_8.OAuth;
import io.fabric8.openshift.api.model.v5_8.OAuthList;
import io.fabric8.openshift.api.model.v5_8.OperatorHub;
import io.fabric8.openshift.api.model.v5_8.OperatorHubList;
import io.fabric8.openshift.api.model.v5_8.Proxy;
import io.fabric8.openshift.api.model.v5_8.ProxyList;
import io.fabric8.openshift.api.model.v5_8.Scheduler;
import io.fabric8.openshift.api.model.v5_8.SchedulerList;
import io.fabric8.openshift.clnt.v5_8.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_8.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.config.DNSOperationsImpl;
import okhttp3.OkHttpClient;

public class OpenShiftConfigAPIGroupClient
extends BaseClient
implements OpenShiftConfigAPIGroupDSL {
    public OpenShiftConfigAPIGroupClient() {
    }

    public OpenShiftConfigAPIGroupClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<APIServer, APIServerList, Resource<APIServer>> apiServers() {
        return OpenShiftHandlers.getOperation(APIServer.class, APIServerList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Authentication, AuthenticationList, Resource<Authentication>> authentications() {
        return OpenShiftHandlers.getOperation(Authentication.class, AuthenticationList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterOperator, ClusterOperatorList, Resource<ClusterOperator>> clusterOperators() {
        return OpenShiftHandlers.getOperation(ClusterOperator.class, ClusterOperatorList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Console, ConsoleList, Resource<Console>> consoles() {
        return OpenShiftHandlers.getOperation(Console.class, ConsoleList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterVersion, ClusterVersionList, Resource<ClusterVersion>> clusterVersions() {
        return OpenShiftHandlers.getOperation(ClusterVersion.class, ClusterVersionList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<DNS, DNSList, Resource<DNS>> dnses() {
        return new DNSOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<FeatureGate, FeatureGateList, Resource<FeatureGate>> featureGates() {
        return OpenShiftHandlers.getOperation(FeatureGate.class, FeatureGateList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Infrastructure, InfrastructureList, Resource<Infrastructure>> infrastructures() {
        return OpenShiftHandlers.getOperation(Infrastructure.class, InfrastructureList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Ingress, IngressList, Resource<Ingress>> ingresses() {
        return OpenShiftHandlers.getOperation(Ingress.class, IngressList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Network, NetworkList, Resource<Network>> networks() {
        return OpenShiftHandlers.getOperation(Network.class, NetworkList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuth, OAuthList, Resource<OAuth>> oAuths() {
        return OpenShiftHandlers.getOperation(OAuth.class, OAuthList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OperatorHub, OperatorHubList, Resource<OperatorHub>> operatorHubs() {
        return OpenShiftHandlers.getOperation(OperatorHub.class, OperatorHubList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Proxy, ProxyList, Resource<Proxy>> proxies() {
        return OpenShiftHandlers.getOperation(Proxy.class, ProxyList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Scheduler, SchedulerList, Resource<Scheduler>> schedulers() {
        return OpenShiftHandlers.getOperation(Scheduler.class, SchedulerList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }
}

