/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_8;

import io.fabric8.kubernetes.api.model.v5_8.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_8.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_8.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_8.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_8.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_8.RootPaths;
import io.fabric8.kubernetes.clnt.v5_8.BaseKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_8.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_8.Handlers;
import io.fabric8.kubernetes.clnt.v5_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_8.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_8.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_8.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.CreateOrDeleteable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_8.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Nameable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.NamespacedInOutCreateable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_8.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_8.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_8.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v5_8.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v5_8.utils.Serialization;
import io.fabric8.openshift.api.model.v5_8.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.v5_8.BrokerTemplateInstanceList;
import io.fabric8.openshift.api.model.v5_8.Build;
import io.fabric8.openshift.api.model.v5_8.BuildConfig;
import io.fabric8.openshift.api.model.v5_8.BuildConfigList;
import io.fabric8.openshift.api.model.v5_8.BuildList;
import io.fabric8.openshift.api.model.v5_8.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_8.ClusterNetworkList;
import io.fabric8.openshift.api.model.v5_8.ClusterRole;
import io.fabric8.openshift.api.model.v5_8.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_8.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v5_8.ClusterRoleList;
import io.fabric8.openshift.api.model.v5_8.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_8.DeploymentConfigList;
import io.fabric8.openshift.api.model.v5_8.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v5_8.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v5_8.Group;
import io.fabric8.openshift.api.model.v5_8.GroupList;
import io.fabric8.openshift.api.model.v5_8.HelmChartRepository;
import io.fabric8.openshift.api.model.v5_8.HelmChartRepositoryList;
import io.fabric8.openshift.api.model.v5_8.HostSubnet;
import io.fabric8.openshift.api.model.v5_8.HostSubnetList;
import io.fabric8.openshift.api.model.v5_8.Identity;
import io.fabric8.openshift.api.model.v5_8.IdentityList;
import io.fabric8.openshift.api.model.v5_8.Image;
import io.fabric8.openshift.api.model.v5_8.ImageList;
import io.fabric8.openshift.api.model.v5_8.ImageSignature;
import io.fabric8.openshift.api.model.v5_8.ImageStream;
import io.fabric8.openshift.api.model.v5_8.ImageStreamImage;
import io.fabric8.openshift.api.model.v5_8.ImageStreamImport;
import io.fabric8.openshift.api.model.v5_8.ImageStreamList;
import io.fabric8.openshift.api.model.v5_8.ImageStreamMapping;
import io.fabric8.openshift.api.model.v5_8.ImageStreamTag;
import io.fabric8.openshift.api.model.v5_8.ImageStreamTagList;
import io.fabric8.openshift.api.model.v5_8.ImageTag;
import io.fabric8.openshift.api.model.v5_8.ImageTagList;
import io.fabric8.openshift.api.model.v5_8.LocalResourceAccessReview;
import io.fabric8.openshift.api.model.v5_8.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v5_8.NetNamespace;
import io.fabric8.openshift.api.model.v5_8.NetNamespaceList;
import io.fabric8.openshift.api.model.v5_8.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_8.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_8.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_8.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v5_8.OAuthClient;
import io.fabric8.openshift.api.model.v5_8.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.v5_8.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.v5_8.OAuthClientList;
import io.fabric8.openshift.api.model.v5_8.PodSecurityPolicyReview;
import io.fabric8.openshift.api.model.v5_8.PodSecurityPolicySelfSubjectReview;
import io.fabric8.openshift.api.model.v5_8.PodSecurityPolicySubjectReview;
import io.fabric8.openshift.api.model.v5_8.RangeAllocation;
import io.fabric8.openshift.api.model.v5_8.RangeAllocationList;
import io.fabric8.openshift.api.model.v5_8.ResourceAccessReview;
import io.fabric8.openshift.api.model.v5_8.ResourceAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_8.Role;
import io.fabric8.openshift.api.model.v5_8.RoleBinding;
import io.fabric8.openshift.api.model.v5_8.RoleBindingList;
import io.fabric8.openshift.api.model.v5_8.RoleBindingRestriction;
import io.fabric8.openshift.api.model.v5_8.RoleBindingRestrictionList;
import io.fabric8.openshift.api.model.v5_8.RoleList;
import io.fabric8.openshift.api.model.v5_8.Route;
import io.fabric8.openshift.api.model.v5_8.RouteList;
import io.fabric8.openshift.api.model.v5_8.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_8.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v5_8.SelfSubjectRulesReview;
import io.fabric8.openshift.api.model.v5_8.SubjectAccessReview;
import io.fabric8.openshift.api.model.v5_8.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_8.SubjectRulesReview;
import io.fabric8.openshift.api.model.v5_8.Template;
import io.fabric8.openshift.api.model.v5_8.TemplateInstance;
import io.fabric8.openshift.api.model.v5_8.TemplateInstanceList;
import io.fabric8.openshift.api.model.v5_8.TemplateList;
import io.fabric8.openshift.api.model.v5_8.User;
import io.fabric8.openshift.api.model.v5_8.UserIdentityMapping;
import io.fabric8.openshift.api.model.v5_8.UserList;
import io.fabric8.openshift.api.model.v5_8.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.v5_8.UserOAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.cloudcredential.v1.CredentialsRequest;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.cloudcredential.v1.CredentialsRequestList;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinitionList;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.imageregistry.operator.v1.Config;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.imageregistry.operator.v1.ConfigList;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.metal3.v1alpha1.BareMetalHostList;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.v5_8.miscellaneous.network.operator.v1.OperatorPKIList;
import io.fabric8.openshift.clnt.v5_8.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftClusterAutoscalingAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_8.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_8.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_8.OpenShiftMachineAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftMachineConfigurationAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftStorageVersionMigratorApiGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftTunedAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenShiftWhereaboutsAPIGroupClient;
import io.fabric8.openshift.clnt.v5_8.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_8.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_8.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_8.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_8.dsl.MachineConfigurationAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.NameableCreateOrDeleteable;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftClusterAutoscalingAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftMachineAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftStorageVersionMigratorApiGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftTunedAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.OpenShiftWhereaboutsAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_8.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v5_8.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v5_8.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.dsl.internal.user.UserOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.internal.OpenShiftClusterOperationsImpl;
import io.fabric8.openshift.clnt.v5_8.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.openshift.clnt.v5_8.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseKubernetesClient<NamespacedOpenShiftClient>
implements NamespacedOpenShiftClient {
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new HashMap<String, Boolean>();
    public static final String AUTHORIZATION_OPENSHIFT_IO = "authorization.openshift.io";
    public static final String V1_APIVERSION = "v1";
    private final URL openShiftUrl;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(io.fabric8.kubernetes.clnt.v5_8.Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        super(DefaultOpenShiftClient.configWithApiGroupsEnabled(DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(config), config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        super(httpClient, DefaultOpenShiftClient.configWithApiGroupsEnabled(httpClient, config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(httpClient, this.getConfiguration());
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    private static OpenShiftConfig configWithApiGroupsEnabled(OkHttpClient httpClient, OpenShiftConfig config) {
        String url = config.getMasterUrl();
        Boolean openshiftApiGroupsEnabled = API_GROUPS_ENABLED_PER_URL.containsKey(url);
        if (openshiftApiGroupsEnabled.booleanValue()) {
            return config;
        }
        if (!config.isDisableApiGroupCheck()) {
            return config.withOpenshiftApiGroupsEnabled(false);
        }
        Boolean enabled = OpenshiftAdapterSupport.isOpenShiftAPIGroups(httpClient, url);
        API_GROUPS_ENABLED_PER_URL.put(url, enabled);
        return config.withOpenshiftApiGroupsEnabled(enabled);
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(io.fabric8.kubernetes.clnt.v5_8.Config config) {
        return DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(null, config);
    }

    static OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient, io.fabric8.kubernetes.clnt.v5_8.Config config) {
        OkHttpClient.Builder builder = httpClient != null ? httpClient.newBuilder().authenticator(Authenticator.NONE) : new OkHttpClient.Builder().authenticator(Authenticator.NONE);
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(config))).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfig getConfiguration() {
        return OpenShiftConfig.wrap(super.getConfiguration());
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftClusterAutoscalingAPIGroupDSL clusterAutoscaling() {
        return this.adapt(OpenShiftClusterAutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), item);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), s);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<CredentialsRequest, CredentialsRequestList, Resource<CredentialsRequest>> credentialsRequests() {
        return OpenShiftHandlers.getOperation(CredentialsRequest.class, CredentialsRequestList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, this.getConfiguration());
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HelmChartRepository, HelmChartRepositoryList, Resource<HelmChartRepository>> helmChartRepositories() {
        return OpenShiftHandlers.getOperation(HelmChartRepository.class, HelmChartRepositoryList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return OpenShiftHandlers.getOperation(Image.class, ImageList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return OpenShiftHandlers.getOperation(ImageTag.class, ImageTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return OpenShiftHandlers.getOperation(ImageStream.class, ImageStreamList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return OpenShiftHandlers.getOperation(ImageStreamTag.class, ImageStreamTagList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamImport, ImageStreamImport> imageStreamImports() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamImport.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<ImageStreamMapping, ImageStreamMapping> imageStreamMappings() {
        return Handlers.getNamespacedHasMetadataCreateOnlyOperation(ImageStreamMapping.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public Namespaceable<Nameable<? extends Gettable<ImageStreamImage>>> imageStreamImages() {
        HasMetadataOperation<ImageStreamImage, ?, Resource<ImageStreamImage>> operation = Handlers.getNonListingOperation(ImageStreamImage.class, this.httpClient, this.getConfiguration());
        return operation::inNamespace;
    }

    @Override
    public NameableCreateOrDeleteable imageSignatures() {
        final HasMetadataOperation<ImageSignature, ?, Resource<ImageSignature>> operation = Handlers.getNonListingOperation(ImageSignature.class, this.httpClient, this.getConfiguration());
        return new NameableCreateOrDeleteable(){

            @Override
            public Boolean delete() {
                return operation.delete();
            }

            @Override
            public ImageSignature create(ImageSignature item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public ImageSignature create(ImageSignature ... item) {
                return (ImageSignature)operation.create(item);
            }

            @Override
            public CreateOrDeleteable<ImageSignature> withName(String name) {
                return operation.withName(name);
            }
        };
    }

    @Override
    public NonNamespaceOperation<Config, ConfigList, Resource<Config>> imageRegistryOperatorConfigs() {
        return OpenShiftHandlers.getOperation(Config.class, ConfigList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<NetworkAttachmentDefinition, NetworkAttachmentDefinitionList, Resource<NetworkAttachmentDefinition>> networkAttachmentDefinitions() {
        return new NetworkAttachmentDefinitionOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicyReview, PodSecurityPolicyReview> podSecurityPolicyReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicyReview.class, PodSecurityPolicyReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<OAuthClientAuthorization, OAuthClientAuthorizationList, Resource<OAuthClientAuthorization>> oAuthClientAuthorizations() {
        return OpenShiftHandlers.getOperation(OAuthClientAuthorization.class, OAuthClientAuthorizationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<OperatorPKI, OperatorPKIList, Resource<OperatorPKI>> operatorPKIs() {
        return OpenShiftHandlers.getOperation(OperatorPKI.class, OperatorPKIList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySelfSubjectReview, PodSecurityPolicySelfSubjectReview> podSecurityPolicySelfSubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySelfSubjectReview.class, PodSecurityPolicySelfSubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<PodSecurityPolicySubjectReview, PodSecurityPolicySubjectReview> podSecurityPolicySubjectReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(PodSecurityPolicySubjectReview.class, PodSecurityPolicySubjectReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return OpenShiftHandlers.getOperation(RangeAllocation.class, RangeAllocationList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return OpenShiftHandlers.getOperation(Route.class, RouteList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<TemplateInstance, TemplateInstanceList, Resource<TemplateInstance>> templateInstances() {
        return OpenShiftHandlers.getOperation(TemplateInstance.class, TemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftTunedAPIGroupDSL tuned() {
        return this.adapt(OpenShiftTunedAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<BrokerTemplateInstance, BrokerTemplateInstanceList, Resource<BrokerTemplateInstance>> brokerTemplateInstances() {
        return OpenShiftHandlers.getOperation(BrokerTemplateInstance.class, BrokerTemplateInstanceList.class, this.httpClient, this.getConfiguration());
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<RoleBindingRestriction, RoleBindingRestrictionList, Resource<RoleBindingRestriction>> roleBindingRestrictions() {
        return OpenShiftHandlers.getOperation(RoleBindingRestriction.class, RoleBindingRestrictionList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        VersionInfo versionInfo = new OpenShiftClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
        return versionInfo == null ? super.getVersion() : versionInfo;
    }

    @Override
    public MachineConfigurationAPIGroupDSL machineConfigurations() {
        return this.adapt(OpenShiftMachineConfigurationAPIGroupClient.class);
    }

    @Override
    public OpenShiftMachineAPIGroupDSL machine() {
        return this.adapt(OpenShiftMachineAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return OpenShiftHandlers.getOperation(NetNamespace.class, NetNamespaceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return OpenShiftHandlers.getOperation(ClusterNetwork.class, ClusterNetworkList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return OpenShiftHandlers.getOperation(EgressNetworkPolicy.class, EgressNetworkPolicyList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> hostSubnets() {
        return OpenShiftHandlers.getOperation(HostSubnet.class, HostSubnetList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<BareMetalHost, BareMetalHostList, Resource<BareMetalHost>> bareMetalHosts() {
        return OpenShiftHandlers.getOperation(BareMetalHost.class, BareMetalHostList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<ResourceAccessReview, ResourceAccessReviewResponse> resourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(ResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalSubjectAccessReview, SubjectAccessReviewResponse> localSubjectAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalSubjectAccessReview.class, SubjectAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<LocalResourceAccessReview, ResourceAccessReviewResponse> localResourceAccessReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(LocalResourceAccessReview.class, ResourceAccessReviewResponse.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SelfSubjectRulesReview, SelfSubjectRulesReview> selfSubjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SelfSubjectRulesReview.class, SelfSubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NamespacedInOutCreateable<SubjectRulesReview, SubjectRulesReview> subjectRulesReviews() {
        return OpenShiftHandlers.getCreateOnlyResourceOperation(SubjectRulesReview.class, SubjectRulesReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftStorageVersionMigratorApiGroupDSL kubeStorageVersionMigrator() {
        return this.adapt(OpenShiftStorageVersionMigratorApiGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> clusterRoles() {
        return OpenShiftHandlers.getOperation(ClusterRole.class, ClusterRoleList.class, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public NonNamespaceOperation<Identity, IdentityList, Resource<Identity>> identities() {
        return OpenShiftHandlers.getOperation(Identity.class, IdentityList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public InOutCreateable<UserIdentityMapping, UserIdentityMapping> userIdentityMappings() {
        return Handlers.getNonListingOperation(UserIdentityMapping.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> userOAuthAccessTokens() {
        return OpenShiftHandlers.getOperation(UserOAuthAccessToken.class, UserOAuthAccessTokenList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public OpenShiftWhereaboutsAPIGroupDSL whereabouts() {
        return this.adapt(OpenShiftWhereaboutsAPIGroupClient.class);
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

