/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1.StorageStateStatus;
import io.fabric8.openshift.api.model.v5_8.storageversionmigrator.v1alpha1.StorageStateStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class StorageStateStatusFluentImpl<A extends StorageStateStatusFluent<A>>
extends BaseFluent<A>
implements StorageStateStatusFluent<A> {
    private String currentStorageVersionHash;
    private String lastHeartbeatTime;
    private List<String> persistedStorageVersionHashes = new ArrayList<String>();

    public StorageStateStatusFluentImpl() {
    }

    public StorageStateStatusFluentImpl(StorageStateStatus instance) {
        this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash());
        this.withLastHeartbeatTime(instance.getLastHeartbeatTime());
        this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes());
    }

    @Override
    public String getCurrentStorageVersionHash() {
        return this.currentStorageVersionHash;
    }

    @Override
    public A withCurrentStorageVersionHash(String currentStorageVersionHash) {
        this.currentStorageVersionHash = currentStorageVersionHash;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentStorageVersionHash() {
        return this.currentStorageVersionHash != null;
    }

    @Override
    @Deprecated
    public A withNewCurrentStorageVersionHash(String arg0) {
        return this.withCurrentStorageVersionHash(new String(arg0));
    }

    @Override
    public String getLastHeartbeatTime() {
        return this.lastHeartbeatTime;
    }

    @Override
    public A withLastHeartbeatTime(String lastHeartbeatTime) {
        this.lastHeartbeatTime = lastHeartbeatTime;
        return (A)this;
    }

    @Override
    public Boolean hasLastHeartbeatTime() {
        return this.lastHeartbeatTime != null;
    }

    @Override
    @Deprecated
    public A withNewLastHeartbeatTime(String arg0) {
        return this.withLastHeartbeatTime(new String(arg0));
    }

    @Override
    public A addToPersistedStorageVersionHashes(Integer index, String item) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        this.persistedStorageVersionHashes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPersistedStorageVersionHashes(Integer index, String item) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        this.persistedStorageVersionHashes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPersistedStorageVersionHashes(String ... items) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPersistedStorageVersionHashes(Collection<String> items) {
        if (this.persistedStorageVersionHashes == null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
        }
        for (String item : items) {
            this.persistedStorageVersionHashes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPersistedStorageVersionHashes(String ... items) {
        for (String item : items) {
            if (this.persistedStorageVersionHashes == null) continue;
            this.persistedStorageVersionHashes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPersistedStorageVersionHashes(Collection<String> items) {
        for (String item : items) {
            if (this.persistedStorageVersionHashes == null) continue;
            this.persistedStorageVersionHashes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPersistedStorageVersionHashes() {
        return this.persistedStorageVersionHashes;
    }

    @Override
    public String getPersistedStorageVersionHash(Integer index) {
        return this.persistedStorageVersionHashes.get(index);
    }

    @Override
    public String getFirstPersistedStorageVersionHash() {
        return this.persistedStorageVersionHashes.get(0);
    }

    @Override
    public String getLastPersistedStorageVersionHash() {
        return this.persistedStorageVersionHashes.get(this.persistedStorageVersionHashes.size() - 1);
    }

    @Override
    public String getMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
        for (String item : this.persistedStorageVersionHashes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPersistedStorageVersionHash(Predicate<String> predicate) {
        for (String item : this.persistedStorageVersionHashes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPersistedStorageVersionHashes(List<String> persistedStorageVersionHashes) {
        if (persistedStorageVersionHashes != null) {
            this.persistedStorageVersionHashes = new ArrayList<String>();
            for (String item : persistedStorageVersionHashes) {
                this.addToPersistedStorageVersionHashes(item);
            }
        } else {
            this.persistedStorageVersionHashes = null;
        }
        return (A)this;
    }

    @Override
    public A withPersistedStorageVersionHashes(String ... persistedStorageVersionHashes) {
        if (this.persistedStorageVersionHashes != null) {
            this.persistedStorageVersionHashes.clear();
        }
        if (persistedStorageVersionHashes != null) {
            for (String item : persistedStorageVersionHashes) {
                this.addToPersistedStorageVersionHashes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPersistedStorageVersionHashes() {
        return this.persistedStorageVersionHashes != null && !this.persistedStorageVersionHashes.isEmpty();
    }

    @Override
    public A addNewPersistedStorageVersionHash(String arg0) {
        return this.addToPersistedStorageVersionHashes(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageStateStatusFluentImpl that = (StorageStateStatusFluentImpl)o;
        if (this.currentStorageVersionHash != null ? !this.currentStorageVersionHash.equals(that.currentStorageVersionHash) : that.currentStorageVersionHash != null) {
            return false;
        }
        if (this.lastHeartbeatTime != null ? !this.lastHeartbeatTime.equals(that.lastHeartbeatTime) : that.lastHeartbeatTime != null) {
            return false;
        }
        return !(this.persistedStorageVersionHashes != null ? !this.persistedStorageVersionHashes.equals(that.persistedStorageVersionHashes) : that.persistedStorageVersionHashes != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentStorageVersionHash, this.lastHeartbeatTime, this.persistedStorageVersionHashes, super.hashCode());
    }
}

