/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_8.operator.v1.Server;
import io.fabric8.openshift.api.model.v5_8.operator.v1.ServerFluent;
import io.fabric8.openshift.api.model.v5_8.operator.v1.ServerFluentImpl;
import java.util.Objects;

public class ServerBuilder
extends ServerFluentImpl<ServerBuilder>
implements VisitableBuilder<Server, ServerBuilder> {
    ServerFluent<?> fluent;
    Boolean validationEnabled;

    public ServerBuilder() {
        this(false);
    }

    public ServerBuilder(Boolean validationEnabled) {
        this(new Server(), validationEnabled);
    }

    public ServerBuilder(ServerFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServerBuilder(ServerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Server(), validationEnabled);
    }

    public ServerBuilder(ServerFluent<?> fluent, Server instance) {
        this(fluent, instance, false);
    }

    public ServerBuilder(ServerFluent<?> fluent, Server instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withForwardPlugin(instance.getForwardPlugin());
        fluent.withName(instance.getName());
        fluent.withZones(instance.getZones());
        this.validationEnabled = validationEnabled;
    }

    public ServerBuilder(Server instance) {
        this(instance, (Boolean)false);
    }

    public ServerBuilder(Server instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withForwardPlugin(instance.getForwardPlugin());
        this.withName(instance.getName());
        this.withZones(instance.getZones());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Server build() {
        Server buildable = new Server(this.fluent.getForwardPlugin(), this.fluent.getName(), this.fluent.getZones());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServerBuilder that = (ServerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

