/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.openshift.api.model.v5_8.DNSZone;
import io.fabric8.openshift.api.model.v5_8.DNSZoneFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DNSZoneFluentImpl<A extends DNSZoneFluent<A>>
extends BaseFluent<A>
implements DNSZoneFluent<A> {
    private String id;
    private Map<String, String> tags;

    public DNSZoneFluentImpl() {
    }

    public DNSZoneFluentImpl(DNSZone instance) {
        this.withId(instance.getId());
        this.withTags(instance.getTags());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public A withId(String id) {
        this.id = id;
        return (A)this;
    }

    @Override
    public Boolean hasId() {
        return this.id != null;
    }

    @Override
    @Deprecated
    public A withNewId(String arg0) {
        return this.withId(new String(arg0));
    }

    @Override
    public A addToTags(String key, String value) {
        if (this.tags == null && key != null && value != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.tags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToTags(Map<String, String> map) {
        if (this.tags == null && map != null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.tags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String key) {
        if (this.tags == null) {
            return (A)this;
        }
        if (key != null && this.tags != null) {
            this.tags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(Map<String, String> map) {
        if (this.tags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.tags == null) continue;
                this.tags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    public <K, V> A withTags(Map<String, String> tags) {
        this.tags = tags == null ? null : new LinkedHashMap<String, String>(tags);
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSZoneFluentImpl that = (DNSZoneFluentImpl)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.tags != null ? !this.tags.equals(that.tags) : that.tags != null);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.tags, super.hashCode());
    }
}

