/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_8.dsl.base;

import io.fabric8.kubernetes.clnt.v5_8.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_8.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_8.dsl.base.OperationSupport;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class CreateOnlyResourceOperation<I, O>
extends OperationSupport
implements InOutCreateable<I, O> {
    protected Class<O> type;

    protected CreateOnlyResourceOperation(OperationContext ctx) {
        super(ctx);
    }

    public Class<O> getType() {
        return this.type;
    }

    protected O handleCreate(I resource) throws ExecutionException, InterruptedException, IOException {
        return this.handleCreate(resource, this.getType());
    }

    @Override
    @SafeVarargs
    public final O create(I ... resources) {
        try {
            if (resources.length > 1) {
                throw new IllegalArgumentException("Too many items to create.");
            }
            if (resources.length == 1) {
                return this.handleCreate(resources[0]);
            }
            return this.handleCreate(this.getItem());
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    @Override
    public O create(I item) {
        try {
            return this.handleCreate(item);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(ie);
        }
    }

    public I getItem() {
        return (I)this.context.getItem();
    }
}

