/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8.rbac;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_8.rbac.PolicyRule;
import io.fabric8.kubernetes.api.model.v5_8.rbac.PolicyRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PolicyRuleFluentImpl<A extends PolicyRuleFluent<A>>
extends BaseFluent<A>
implements PolicyRuleFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private List<String> nonResourceURLs = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private List<String> verbs = new ArrayList<String>();

    public PolicyRuleFluentImpl() {
    }

    public PolicyRuleFluentImpl(PolicyRule instance) {
        this.withApiGroups(instance.getApiGroups());
        this.withNonResourceURLs(instance.getNonResourceURLs());
        this.withResourceNames(instance.getResourceNames());
        this.withResources(instance.getResources());
        this.withVerbs(instance.getVerbs());
    }

    @Override
    public A addToApiGroups(Integer index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiGroups(Integer index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiGroups(String ... items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    @Override
    public String getApiGroup(Integer index) {
        return this.apiGroups.get(index);
    }

    @Override
    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    @Override
    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    @Override
    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    @Override
    public A addNewApiGroup(String arg0) {
        return this.addToApiGroups(new String(arg0));
    }

    @Override
    public A addToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNonResourceURLs(Integer index, String item) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNonResourceURLs(String ... items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNonResourceURLs(Collection<String> items) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        for (String item : items) {
            this.nonResourceURLs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNonResourceURLs(String ... items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNonResourceURLs(Collection<String> items) {
        for (String item : items) {
            if (this.nonResourceURLs == null) continue;
            this.nonResourceURLs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    @Override
    public String getNonResourceURL(Integer index) {
        return this.nonResourceURLs.get(index);
    }

    @Override
    public String getFirstNonResourceURL() {
        return this.nonResourceURLs.get(0);
    }

    @Override
    public String getLastNonResourceURL() {
        return this.nonResourceURLs.get(this.nonResourceURLs.size() - 1);
    }

    @Override
    public String getMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNonResourceURL(Predicate<String> predicate) {
        for (String item : this.nonResourceURLs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNonResourceURLs(List<String> nonResourceURLs) {
        if (nonResourceURLs != null) {
            this.nonResourceURLs = new ArrayList<String>();
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        } else {
            this.nonResourceURLs = null;
        }
        return (A)this;
    }

    @Override
    public A withNonResourceURLs(String ... nonResourceURLs) {
        if (this.nonResourceURLs != null) {
            this.nonResourceURLs.clear();
        }
        if (nonResourceURLs != null) {
            for (String item : nonResourceURLs) {
                this.addToNonResourceURLs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceURLs() {
        return this.nonResourceURLs != null && !this.nonResourceURLs.isEmpty();
    }

    @Override
    public A addNewNonResourceURL(String arg0) {
        return this.addToNonResourceURLs(new String(arg0));
    }

    @Override
    public A addToResourceNames(Integer index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResourceNames(Integer index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResourceNames(String ... items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceNames(String ... items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceNames(Collection<String> items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public String getResourceName(Integer index) {
        return this.resourceNames.get(index);
    }

    @Override
    public String getFirstResourceName() {
        return this.resourceNames.get(0);
    }

    @Override
    public String getLastResourceName() {
        return this.resourceNames.get(this.resourceNames.size() - 1);
    }

    @Override
    public String getMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceNames(List<String> resourceNames) {
        if (resourceNames != null) {
            this.resourceNames = new ArrayList<String>();
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        } else {
            this.resourceNames = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceNames(String ... resourceNames) {
        if (this.resourceNames != null) {
            this.resourceNames.clear();
        }
        if (resourceNames != null) {
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceNames() {
        return this.resourceNames != null && !this.resourceNames.isEmpty();
    }

    @Override
    public A addNewResourceName(String arg0) {
        return this.addToResourceNames(new String(arg0));
    }

    @Override
    public A addToResources(Integer index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(Integer index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(String ... items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public String getResource(Integer index) {
        return this.resources.get(index);
    }

    @Override
    public String getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public A addNewResource(String arg0) {
        return this.addToResources(new String(arg0));
    }

    @Override
    public A addToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVerbs(Integer index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVerbs(String ... items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVerbs(Collection<String> items) {
        for (String item : items) {
            if (this.verbs == null) continue;
            this.verbs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVerbs() {
        return this.verbs;
    }

    @Override
    public String getVerb(Integer index) {
        return this.verbs.get(index);
    }

    @Override
    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    @Override
    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    @Override
    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    @Override
    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public A addNewVerb(String arg0) {
        return this.addToVerbs(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyRuleFluentImpl that = (PolicyRuleFluentImpl)o;
        if (this.apiGroups != null ? !this.apiGroups.equals(that.apiGroups) : that.apiGroups != null) {
            return false;
        }
        if (this.nonResourceURLs != null ? !this.nonResourceURLs.equals(that.nonResourceURLs) : that.nonResourceURLs != null) {
            return false;
        }
        if (this.resourceNames != null ? !this.resourceNames.equals(that.resourceNames) : that.resourceNames != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.verbs != null ? !this.verbs.equals(that.verbs) : that.verbs != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.nonResourceURLs, this.resourceNames, this.resources, this.verbs, super.hashCode());
    }
}

