/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2.ContainerResourceMetricSource;
import io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2.ContainerResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2.MetricTarget;
import io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2.MetricTargetBuilder;
import io.fabric8.kubernetes.api.model.v5_8.autoscaling.v2beta2.MetricTargetFluentImpl;
import java.util.Objects;

public class ContainerResourceMetricSourceFluentImpl<A extends ContainerResourceMetricSourceFluent<A>>
extends BaseFluent<A>
implements ContainerResourceMetricSourceFluent<A> {
    private String container;
    private String name;
    private MetricTargetBuilder target;

    public ContainerResourceMetricSourceFluentImpl() {
    }

    public ContainerResourceMetricSourceFluentImpl(ContainerResourceMetricSource instance) {
        this.withContainer(instance.getContainer());
        this.withName(instance.getName());
        this.withTarget(instance.getTarget());
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    @Deprecated
    public A withNewContainer(String arg0) {
        return this.withContainer(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    @Deprecated
    public MetricTarget getTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public MetricTarget buildTarget() {
        return this.target != null ? this.target.build() : null;
    }

    @Override
    public A withTarget(MetricTarget target) {
        this._visitables.get("target").remove(this.target);
        if (target != null) {
            this.target = new MetricTargetBuilder(target);
            this._visitables.get("target").add(this.target);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTarget() {
        return this.target != null;
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> withNewTargetLike(MetricTarget item) {
        return new TargetNestedImpl(item);
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editTarget() {
        return this.withNewTargetLike(this.getTarget());
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editOrNewTarget() {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : new MetricTargetBuilder().build());
    }

    @Override
    public ContainerResourceMetricSourceFluent.TargetNested<A> editOrNewTargetLike(MetricTarget item) {
        return this.withNewTargetLike(this.getTarget() != null ? this.getTarget() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerResourceMetricSourceFluentImpl that = (ContainerResourceMetricSourceFluentImpl)o;
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(that.target) : that.target != null);
    }

    public int hashCode() {
        return Objects.hash(this.container, this.name, this.target, super.hashCode());
    }

    public class TargetNestedImpl<N>
    extends MetricTargetFluentImpl<ContainerResourceMetricSourceFluent.TargetNested<N>>
    implements ContainerResourceMetricSourceFluent.TargetNested<N>,
    Nested<N> {
        MetricTargetBuilder builder;

        TargetNestedImpl(MetricTarget item) {
            this.builder = new MetricTargetBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new MetricTargetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerResourceMetricSourceFluentImpl.this.withTarget(this.builder.build());
        }

        @Override
        public N endTarget() {
            return this.and();
        }
    }
}

