/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_8.Nested;
import io.fabric8.kubernetes.api.model.v5_8.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_8.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_8.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v5_8.StorageOSPersistentVolumeSource;
import io.fabric8.kubernetes.api.model.v5_8.StorageOSPersistentVolumeSourceFluent;
import java.util.Objects;

public class StorageOSPersistentVolumeSourceFluentImpl<A extends StorageOSPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements StorageOSPersistentVolumeSourceFluent<A> {
    private String fsType;
    private Boolean readOnly;
    private ObjectReferenceBuilder secretRef;
    private String volumeName;
    private String volumeNamespace;

    public StorageOSPersistentVolumeSourceFluentImpl() {
    }

    public StorageOSPersistentVolumeSourceFluentImpl(StorageOSPersistentVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withVolumeName(instance.getVolumeName());
        this.withVolumeNamespace(instance.getVolumeNamespace());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public A withNewFsType(String arg0) {
        return this.withFsType(new String(arg0));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public ObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public ObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(ObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new ObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public StorageOSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeName(String arg0) {
        return this.withVolumeName(new String(arg0));
    }

    @Override
    public String getVolumeNamespace() {
        return this.volumeNamespace;
    }

    @Override
    public A withVolumeNamespace(String volumeNamespace) {
        this.volumeNamespace = volumeNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeNamespace() {
        return this.volumeNamespace != null;
    }

    @Override
    @Deprecated
    public A withNewVolumeNamespace(String arg0) {
        return this.withVolumeNamespace(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageOSPersistentVolumeSourceFluentImpl that = (StorageOSPersistentVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.volumeNamespace != null ? !this.volumeNamespace.equals(that.volumeNamespace) : that.volumeNamespace != null);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.secretRef, this.volumeName, this.volumeNamespace, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements StorageOSPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        SecretRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)StorageOSPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

