/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_8.Quantity;
import io.fabric8.kubernetes.api.model.v5_8.QuantityFluent;
import io.fabric8.kubernetes.api.model.v5_8.QuantityFluentImpl;
import java.util.Objects;

public class QuantityBuilder
extends QuantityFluentImpl<QuantityBuilder>
implements VisitableBuilder<Quantity, QuantityBuilder> {
    QuantityFluent<?> fluent;
    Boolean validationEnabled;

    public QuantityBuilder() {
        this(false);
    }

    public QuantityBuilder(Boolean validationEnabled) {
        this(new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Quantity(), validationEnabled);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance) {
        this(fluent, instance, false);
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAmount(instance.getAmount());
        fluent.withFormat(instance.getFormat());
        this.validationEnabled = validationEnabled;
    }

    public QuantityBuilder(Quantity instance) {
        this(instance, (Boolean)false);
    }

    public QuantityBuilder(Quantity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAmount(instance.getAmount());
        this.withFormat(instance.getFormat());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Quantity build() {
        Quantity buildable = new Quantity(this.fluent.getAmount());
        buildable.setFormat(this.fluent.getFormat());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuantityBuilder that = (QuantityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

