/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_8;

import io.fabric8.kubernetes.api.builder.v5_8.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_8.PodSecurityContext;
import io.fabric8.kubernetes.api.model.v5_8.PodSecurityContextFluent;
import io.fabric8.kubernetes.api.model.v5_8.PodSecurityContextFluentImpl;
import java.util.Objects;

public class PodSecurityContextBuilder
extends PodSecurityContextFluentImpl<PodSecurityContextBuilder>
implements VisitableBuilder<PodSecurityContext, PodSecurityContextBuilder> {
    PodSecurityContextFluent<?> fluent;
    Boolean validationEnabled;

    public PodSecurityContextBuilder() {
        this(false);
    }

    public PodSecurityContextBuilder(Boolean validationEnabled) {
        this(new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodSecurityContext(), validationEnabled);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance) {
        this(fluent, instance, false);
    }

    public PodSecurityContextBuilder(PodSecurityContextFluent<?> fluent, PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
        fluent.withRunAsGroup(instance.getRunAsGroup());
        fluent.withRunAsNonRoot(instance.getRunAsNonRoot());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxOptions(instance.getSeLinuxOptions());
        fluent.withSeccompProfile(instance.getSeccompProfile());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withSysctls(instance.getSysctls());
        fluent.withWindowsOptions(instance.getWindowsOptions());
        this.validationEnabled = validationEnabled;
    }

    public PodSecurityContextBuilder(PodSecurityContext instance) {
        this(instance, (Boolean)false);
    }

    public PodSecurityContextBuilder(PodSecurityContext instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFsGroup(instance.getFsGroup());
        this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.getRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
        this.withSeccompProfile(instance.getSeccompProfile());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withSysctls(instance.getSysctls());
        this.withWindowsOptions(instance.getWindowsOptions());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodSecurityContext build() {
        PodSecurityContext buildable = new PodSecurityContext(this.fluent.getFsGroup(), this.fluent.getFsGroupChangePolicy(), this.fluent.getRunAsGroup(), this.fluent.getRunAsNonRoot(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxOptions(), this.fluent.getSeccompProfile(), this.fluent.getSupplementalGroups(), this.fluent.getSysctls(), this.fluent.getWindowsOptions());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityContextBuilder that = (PodSecurityContextBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

